/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.nn.testtool.transform.TransformerFactoryErrorListener;
import nl.nn.testtool.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportXmlTransformer {
    private Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String xslt;
    private Transformer transformer;
    private String createTransformerError;
    private Exception createTransformerException;

    public void setXsltResource(String xsltResource) {
        StringBuffer result = new StringBuffer();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(xsltResource);
        if (stream == null) {
            this.createTransformerError = "Could not find xslt resource: " + xsltResource;
        } else {
            byte[] bytes = new byte[1024];
            try {
                int i = stream.read(bytes);
                while (i != -1) {
                    result.append(new String(bytes, 0, i, "UTF-8"));
                    i = stream.read(bytes);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.createTransformerError = "UnsupportedEncodingException reading xslt";
                this.createTransformerException = unsupportedEncodingException;
                this.log.debug(this.createTransformerError, (Throwable)this.createTransformerException);
            }
            catch (IOException ioException) {
                this.createTransformerError = "IOException reading xslt";
                this.createTransformerException = ioException;
                this.log.debug(this.createTransformerError, (Throwable)this.createTransformerException);
            }
        }
        if (this.createTransformerError == null) {
            this.setXslt(result.toString());
        }
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
        TransformerFactory transformerFactory = XmlUtil.getTransformerFactory();
        TransformerFactoryErrorListener transformerFactoryErrorListener = new TransformerFactoryErrorListener();
        transformerFactory.setErrorListener(transformerFactoryErrorListener);
        try {
            this.transformer = transformerFactory.newTransformer(new StreamSource(new StringReader(xslt)));
        }
        catch (TransformerConfigurationException e) {
            this.createTransformerError = "Could not create transformer: " + e.getMessageAndLocation() + " " + transformerFactoryErrorListener.getErrorMessages();
            this.createTransformerException = e;
            this.log.debug(this.createTransformerError, (Throwable)this.createTransformerException);
        }
    }

    public String updateXslt(String xslt) {
        this.createTransformerError = null;
        this.createTransformerException = null;
        this.setXslt(xslt);
        if (this.createTransformerError == null) {
            return null;
        }
        return this.createTransformerError;
    }

    public String getXslt() {
        return this.xslt;
    }

    public String transform(String xml) {
        StringWriter stringWriter = new StringWriter();
        if (this.createTransformerError != null) {
            this.printException(this.createTransformerError, this.createTransformerException, stringWriter);
            stringWriter.write("\n");
            this.printFirstXmlCharacters(xml, stringWriter);
        } else {
            StreamSource streamSource = new StreamSource(new StringReader(xml));
            StreamResult streamResult = new StreamResult(stringWriter);
            try {
                this.transformer.transform(streamSource, streamResult);
            }
            catch (TransformerException e) {
                String message = "Could not transform report xml";
                this.log.debug(message, (Throwable)e);
                this.printException(message, e, stringWriter);
                stringWriter.write("\n");
                this.printFirstXmlCharacters(xml, stringWriter);
            }
        }
        return stringWriter.toString();
    }

    private void printException(String message, Exception e, StringWriter stringWriter) {
        stringWriter.write(message);
        if (e != null) {
            stringWriter.write(": " + e.getMessage());
            stringWriter.write("\n\n");
            stringWriter.write("Stacktrace:\n");
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            printWriter.close();
        }
    }

    private void printFirstXmlCharacters(String xml, StringWriter stringWriter) {
        int i = 10000;
        if (xml.length() < i) {
            i = xml.length();
        }
        stringWriter.write("First " + i + " characters of xml to transform:\n" + xml.substring(0, i));
    }
}

