/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.util;

import java.util.List;

public class EscapeUtil {
    public static String escapeXml(String value) {
        if (value == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '<') {
                result.append("&lt;");
                continue;
            }
            if (value.charAt(i) == '>') {
                result.append("&gt;");
                continue;
            }
            if (value.charAt(i) == '\"') {
                result.append("&quot;");
                continue;
            }
            if (value.charAt(i) == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(value.charAt(i));
        }
        return result.toString();
    }

    public static String escapeCsv(String value) {
        if (value == null) {
            value = "";
        } else {
            boolean specialCharsFound = false;
            if (value.length() == 0) {
                specialCharsFound = true;
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c == '\"') {
                        specialCharsFound = true;
                        value = value.substring(0, i) + "\"" + value.substring(i);
                        ++i;
                        continue;
                    }
                    if (c != ',' && c != '\n' && c != '\r') continue;
                    specialCharsFound = true;
                }
            }
            if (specialCharsFound) {
                value = "\"" + value + "\"";
            }
        }
        return value;
    }

    public static String escapeCsv(List values) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < values.size() - 1; ++i) {
            stringBuffer.append(EscapeUtil.escapeCsv((String)values.get(i)));
            stringBuffer.append(",");
        }
        stringBuffer.append(EscapeUtil.escapeCsv((String)values.get(values.size() - 1)));
        return stringBuffer.toString();
    }
}

