/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.util;

import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.ExportResult;
import nl.nn.testtool.util.Import;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static ExportResult export(Storage storage) {
        return Export.export(storage, null);
    }

    public static ExportResult export(Storage storage, List storageIds, boolean exportReport, boolean exportReportXml) {
        return Export.export(storage, storageIds, null, exportReport, exportReportXml, null, null);
    }

    public static ExportResult export(Storage storage, String suggestedFilenameWithoutExtension) {
        return Export.export(storage, suggestedFilenameWithoutExtension, true, false);
    }

    public static ExportResult export(Storage storage, String suggestedFilenameWithoutExtension, boolean exportReport, boolean exportReportXml) {
        return Export.export(storage, null, exportReport, exportReportXml, null, suggestedFilenameWithoutExtension);
    }

    public static ExportResult export(Report report) {
        return Export.export(report, true, false);
    }

    public static ExportResult export(Report report, boolean exportReport, boolean exportReportXml) {
        return Export.export(null, report, exportReport, exportReportXml, null, null);
    }

    public static ExportResult export(Report report, Checkpoint checkpoint) {
        return Export.export(null, report, true, false, checkpoint, null);
    }

    public static ExportResult export(Checkpoint checkpoint) {
        return Export.export(null, null, false, false, checkpoint, null);
    }

    private static ExportResult export(Storage storage, Report report, boolean exportReport, boolean exportReportXml, Checkpoint checkpoint, String suggestedFilenameWithoutExtension) {
        return Export.export(storage, null, report, exportReport, exportReportXml, checkpoint, suggestedFilenameWithoutExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExportResult export(Storage storage, List storageIds, Report report, boolean exportReport, boolean exportReportXml, Checkpoint checkpoint, String suggestedFilenameWithoutExtension) {
        ZipOutputStream zipOutputStream;
        FileOutputStream fileOutputStream;
        ExportResult exportResult;
        block19: {
            exportResult = new ExportResult();
            fileOutputStream = null;
            zipOutputStream = null;
            try {
                if (storage != null) {
                    if (storageIds == null || storageIds.isEmpty()) {
                        storageIds = storage.getStorageIds();
                    }
                    if (suggestedFilenameWithoutExtension == null) {
                        suggestedFilenameWithoutExtension = "Ladybug " + storage.getName();
                        suggestedFilenameWithoutExtension = suggestedFilenameWithoutExtension + " " + new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
                        int size = storageIds.size();
                        suggestedFilenameWithoutExtension = suggestedFilenameWithoutExtension + " (" + size;
                        suggestedFilenameWithoutExtension = size == 1 ? suggestedFilenameWithoutExtension + " report)" : suggestedFilenameWithoutExtension + " reports)";
                    }
                    fileOutputStream = Export.createTempFile(suggestedFilenameWithoutExtension, ".zip", exportResult);
                    zipOutputStream = new ZipOutputStream(fileOutputStream);
                    HashSet<String> duplicateCheck = new HashSet<String>();
                    Iterator iterator = storageIds.iterator();
                    while (iterator.hasNext()) {
                        block18: {
                            try {
                                report = storage.getReport((Integer)iterator.next());
                                if (report == null) {
                                }
                                break block18;
                            }
                            catch (Exception e) {
                                exportResult.setErrorMessage(e.toString());
                            }
                            continue;
                        }
                        int duplicateNumber = 1;
                        String zipEntryName = Export.getZipEntryName(report, duplicateNumber);
                        while (duplicateCheck.contains(zipEntryName)) {
                            zipEntryName = Export.getZipEntryName(report, ++duplicateNumber);
                        }
                        duplicateCheck.add(zipEntryName);
                        if (exportReport) {
                            Export.writeReport(report, zipEntryName, zipOutputStream);
                        }
                        if (!exportReportXml) continue;
                        String reportXml = report.toXml();
                        zipEntryName = zipEntryName.substring(0, zipEntryName.length() - 4) + Export.getFileExtension(reportXml);
                        Export.writeReportXml(reportXml, zipEntryName, zipOutputStream);
                    }
                    break block19;
                }
                if (report != null && !exportReport && exportReportXml) {
                    String reportXml = report.toXml();
                    fileOutputStream = Export.createTempFile(Export.replaceSpecialCharsInFilename(report.getName()), Export.getFileExtension(reportXml), exportResult);
                    fileOutputStream.write(Export.getMessageBytes(reportXml));
                    break block19;
                }
                if (report != null && (exportReportXml || checkpoint != null)) {
                    fileOutputStream = Export.createTempFile(Export.replaceSpecialCharsInFilename(report.getName()), ".zip", exportResult);
                    zipOutputStream = new ZipOutputStream(fileOutputStream);
                    String zipEntryName = Export.getZipEntryName(report, 1);
                    Export.writeReport(report, zipEntryName, zipOutputStream);
                    if (exportReportXml) {
                        String reportXml = report.toXml();
                        zipEntryName = zipEntryName.substring(0, zipEntryName.length() - 4) + Export.getFileExtension(reportXml);
                        Export.writeReportXml(reportXml, zipEntryName, zipOutputStream);
                    }
                    if (checkpoint != null) {
                        zipEntryName = Export.replaceSpecialCharsInFilename(checkpoint.getName()) + Export.getFileExtension(checkpoint.getMessage());
                        Export.writeCheckpoint(checkpoint, zipEntryName, zipOutputStream);
                    }
                    break block19;
                }
                if (report != null) {
                    fileOutputStream = Export.createTempFile(Export.replaceSpecialCharsInFilename(report.getName()), ".ttr", exportResult);
                    fileOutputStream.write(Export.getReportBytesPortable(report));
                    break block19;
                }
                if (checkpoint == null) break block19;
                fileOutputStream = Export.createTempFile(Export.replaceSpecialCharsInFilename(checkpoint.getName()), Export.getFileExtension(checkpoint.getMessage()), exportResult);
                fileOutputStream.write(Export.getMessageBytes(checkpoint.getMessage()));
            }
            catch (Throwable throwable) {
                block20: {
                    try {
                        log.error("Caught throwable creating file", throwable);
                        exportResult.setErrorMessage("Unable to create export: " + throwable.getMessage());
                        if (exportResult.getTempFile() == null) break block20;
                        exportResult.getTempFile().delete();
                    }
                    catch (Throwable throwable2) {
                        Export.closeOutputStream(zipOutputStream, "closing zipOutputStream", log);
                        Export.closeOutputStream(fileOutputStream, "closing fileOutputStream", log);
                        throw throwable2;
                    }
                }
                Export.closeOutputStream(zipOutputStream, "closing zipOutputStream", log);
                Export.closeOutputStream(fileOutputStream, "closing fileOutputStream", log);
            }
        }
        Export.closeOutputStream(zipOutputStream, "closing zipOutputStream", log);
        Export.closeOutputStream(fileOutputStream, "closing fileOutputStream", log);
        return exportResult;
    }

    private static FileOutputStream createTempFile(String suggestedFilenameWithoutExtension, String extension, ExportResult exportResult) throws IOException {
        File file = File.createTempFile("testtool-", extension);
        file.deleteOnExit();
        log.debug("Temporary file name: " + file.getAbsolutePath());
        exportResult.setTempFile(file);
        exportResult.setSuggestedFilename(Export.replaceSpecialCharsInFilename(suggestedFilenameWithoutExtension) + extension);
        return new FileOutputStream(file);
    }

    private static String getFileExtension(String message) {
        if (message != null && message.startsWith("<")) {
            return ".xml";
        }
        return ".txt";
    }

    private static String getZipEntryName(Report report, int duplicateNumber) {
        String name = Export.replaceSpecialCharsInFilename(report.getName());
        if (report.getPath() != null) {
            name = Export.replaceSpecialCharsInPath(report.getPath()) + name;
        }
        if (duplicateNumber > 1) {
            name = name + " (" + duplicateNumber + ")";
        }
        if ((name = name + ".ttr").startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    private static String replaceSpecialCharsInFilename(String filename) {
        return Export.replaceSpecialCharsInPath(filename).replaceAll("/", "_").replaceAll("\\\\", "_");
    }

    private static String replaceSpecialCharsInPath(String path) {
        return path.replaceAll(":", "_");
    }

    private static void writeReport(Report report, String zipEntryName, ZipOutputStream zipOutputStream) throws IOException {
        Export.writeZipEntry(zipEntryName, Export.getReportBytesPortable(report), zipOutputStream);
    }

    private static void writeReportXml(String reportXml, String zipEntryName, ZipOutputStream zipOutputStream) throws IOException {
        Export.writeZipEntry(zipEntryName, Export.getMessageBytes(reportXml), zipOutputStream);
    }

    private static void writeCheckpoint(Checkpoint checkpoint, String zipEntryName, ZipOutputStream zipOutputStream) throws IOException {
        Export.writeZipEntry(zipEntryName, Export.getMessageBytes(checkpoint.getMessage()), zipOutputStream);
    }

    private static void writeZipEntry(String zipEntryName, byte[] bytes, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(zipEntryName));
        zipOutputStream.write(bytes);
        zipOutputStream.closeEntry();
    }

    private static byte[] getMessageBytes(String message) throws UnsupportedEncodingException {
        if (message == null) {
            return new byte[0];
        }
        return message.getBytes("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getReportBytesPortable(Report report) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = null;
        XMLEncoder xmlEncoder = null;
        try {
            gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            xmlEncoder = new XMLEncoder(gzipOutputStream);
            xmlEncoder.writeObject(TestTool.getVersion());
            xmlEncoder.writeObject(report);
        }
        catch (Throwable throwable) {
            Export.closeXMLEncoder(xmlEncoder);
            Export.closeOutputStream(gzipOutputStream, "closing gzipOutputStream", log);
            throw throwable;
        }
        Export.closeXMLEncoder(xmlEncoder);
        Export.closeOutputStream(gzipOutputStream, "closing gzipOutputStream", log);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getReportBytes(Report report) throws StorageException {
        GZIPOutputStream gzipOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block8: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            gzipOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                objectOutputStream = new ObjectOutputStream(gzipOutputStream);
                objectOutputStream.writeObject(report);
                if (objectOutputStream == null) break block8;
            }
            catch (IOException e) {
                block9: {
                    try {
                        Export.logAndThrow(log, e, "IOException storing report");
                        if (objectOutputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (objectOutputStream != null) {
                            Export.closeOutputStream(objectOutputStream, "closing object output stream after getting report bytes", log);
                        }
                        if (gzipOutputStream != null) {
                            Export.closeOutputStream(gzipOutputStream, "closing gzip output stream after getting report bytes", log);
                        }
                        Export.closeOutputStream(byteArrayOutputStream, "closing byte array output stream after getting report bytes", log);
                        throw throwable;
                    }
                    Export.closeOutputStream(objectOutputStream, "closing object output stream after getting report bytes", log);
                }
                if (gzipOutputStream != null) {
                    Export.closeOutputStream(gzipOutputStream, "closing gzip output stream after getting report bytes", log);
                }
                Export.closeOutputStream(byteArrayOutputStream, "closing byte array output stream after getting report bytes", log);
            }
            Export.closeOutputStream(objectOutputStream, "closing object output stream after getting report bytes", log);
        }
        if (gzipOutputStream != null) {
            Export.closeOutputStream(gzipOutputStream, "closing gzip output stream after getting report bytes", log);
        }
        Export.closeOutputStream(byteArrayOutputStream, "closing byte array output stream after getting report bytes", log);
        return byteArrayOutputStream.toByteArray();
    }

    public static void closeXMLEncoder(XMLEncoder xmlEncoder) {
        if (xmlEncoder != null) {
            xmlEncoder.close();
        }
    }

    public static void closeOutputStream(OutputStream outputStream, String action, Logger log) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.warn("IOException " + action, (Throwable)e);
            }
        }
    }

    public static void closeOutputStreamWriter(OutputStreamWriter outputStreamWriter, String action, Logger log) {
        try {
            outputStreamWriter.close();
        }
        catch (IOException e) {
            log.warn("IOException " + action, (Throwable)e);
        }
    }

    public static void logAndThrow(Logger log, String message) throws StorageException {
        Import.logAndThrow(log, message);
    }

    public static void logAndThrow(Logger log, Exception e, String message) throws StorageException {
        Import.logAndThrow(log, e, message);
    }
}

