/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.CSVReader;
import nl.nn.testtool.util.ImportResult;
import nl.nn.xmldecoder.XMLDecoder;
import org.slf4j.Logger;

public class Import {
    public static String importZip(InputStream inputStream, CrudStorage storage, Logger log) {
        String errorMessage = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        ArrayList<ImportResult> importResults = new ArrayList<ImportResult>();
        try {
            int counter = 0;
            zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && errorMessage == null) {
                log.debug("Process zip entry: " + zipEntry.getName());
                if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(".ttr")) {
                    ++counter;
                    byte[] reportBytes = new byte[]{};
                    byte[] buffer = new byte[1000];
                    int length = zipInputStream.read(buffer);
                    while (length != -1) {
                        byte[] tmpBytes = new byte[reportBytes.length + length];
                        System.arraycopy(reportBytes, 0, tmpBytes, 0, reportBytes.length);
                        System.arraycopy(buffer, 0, tmpBytes, reportBytes.length, length);
                        reportBytes = tmpBytes;
                        length = zipInputStream.read(buffer);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(reportBytes);
                    ImportResult importResult = Import.importTtr(byteArrayInputStream, storage, log);
                    importResults.add(importResult);
                    errorMessage = importResult.errorMessage;
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            if (counter < 1) {
                errorMessage = "No ttr files found in zip";
            }
            for (ImportResult importResult : importResults) {
                Report report;
                if (importResult.newStorageId == null || !(report = storage.getReport(importResult.newStorageId)).getInputCheckpoint().containsVariables()) continue;
                if (report.getInputCheckpoint().updateVariables(importResults)) {
                    storage.update(report);
                    log.debug("Updated report [" + report.getFullPath() + "]'s input variable(s) with target report's updated storageId(s)");
                    continue;
                }
                log.warn("Could not update report [" + report.getFullPath() + "]'s input variables on uploading - please review manually");
            }
        }
        catch (IOException e) {
            errorMessage = "IOException on zip import";
            log.warn(errorMessage, (Throwable)e);
            errorMessage = errorMessage + ": " + e.getMessage();
        }
        catch (StorageException e) {
            errorMessage = "StorageException on zip import";
            log.warn(errorMessage, (Throwable)e);
            errorMessage = errorMessage + ": " + e.getMessage();
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportResult importTtr(InputStream inputStream, CrudStorage storage, Logger log) {
        GZIPInputStream gzipInputStream = null;
        XMLDecoder xmlDecoder = null;
        String version = null;
        Report report = null;
        ImportResult importResult = new ImportResult();
        try {
            gzipInputStream = new GZIPInputStream(inputStream);
            xmlDecoder = new XMLDecoder(gzipInputStream);
            version = (String)xmlDecoder.readObject();
            if (log != null) {
                log.debug("Decoded version: " + version);
            }
            report = (Report)xmlDecoder.readObject();
            importResult.oldStorageId = report.getStorageId();
            while (report != null) {
                storage.store(report);
                report = (Report)xmlDecoder.readObject();
                if (log == null) continue;
                log.debug("Decoded report: " + report.getName());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (log != null) {
                log.debug("Last report in file read");
            }
        }
        catch (Throwable t) {
            importResult.errorMessage = "Caught unexpected throwable during import: " + t.getClass().getTypeName() + ": " + t.getMessage();
            if (log != null) {
                log.error(importResult.errorMessage, t);
            }
        }
        finally {
            if (report != null) {
                importResult.newStorageId = report.getStorageId();
            }
            if (xmlDecoder != null) {
                xmlDecoder.close();
            }
            if (gzipInputStream != null) {
                Import.closeInputStream(gzipInputStream, "closing gzip input stream after ttr import", log);
            }
            if (inputStream != null) {
                Import.closeInputStream(gzipInputStream, "closing input stream after ttr import", log);
            }
        }
        return importResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Report getReport(InputStream inputStream, Integer storageId, Long storageSize, Logger log) throws StorageException {
        Report report = null;
        GZIPInputStream gzipInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            gzipInputStream = new GZIPInputStream(inputStream);
            objectInputStream = new ObjectInputStream(gzipInputStream);
            report = (Report)objectInputStream.readObject();
            report.setStorageId(storageId);
            report.setStorageSize(storageSize);
        }
        catch (IOException e) {
            Import.logAndThrow(log, e, "IOException reading report " + storageId + " from bytes");
        }
        catch (ClassNotFoundException e) {
            Import.logAndThrow(log, e, "ClassNotFoundException reading report " + storageId + " from file");
        }
        finally {
            if (objectInputStream != null) {
                Import.closeInputStream(objectInputStream, "closing object input stream after reading report " + storageId + " from file", log);
            }
            if (gzipInputStream != null) {
                Import.closeInputStream(gzipInputStream, "closing gzip input stream after reading report " + storageId + " from file", log);
            }
        }
        return report;
    }

    public static void closeInputStream(InputStream inputStream, String action, Logger log) {
        block2: {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                if (log == null) break block2;
                log.warn("IOException " + action, (Throwable)e);
            }
        }
    }

    public static void closeReader(Reader reader, String action, Logger log) {
        try {
            reader.close();
        }
        catch (IOException e) {
            log.warn("IOException " + action, (Throwable)e);
        }
    }

    public static void closeCSVReader(CSVReader csvReader, String action, Logger log) {
        try {
            csvReader.close();
        }
        catch (IOException e) {
            log.warn("IOException " + action, (Throwable)e);
        }
    }

    public static void logAndThrow(Logger log, String message) throws StorageException {
        log.error(message);
        throw new StorageException(message);
    }

    public static void logAndThrow(Logger log, Exception e, String message) throws StorageException {
        message = message + ": " + e.getMessage();
        log.error(message, (Throwable)e);
        throw new StorageException(message, e);
    }
}

