/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.util;

import java.util.List;
import java.util.StringTokenizer;

public class SearchUtil {
    public static boolean matches(List values, List searchValues) {
        if (searchValues != null) {
            for (int i = 0; i < values.size(); ++i) {
                String searchValue;
                Object value = values.get(i);
                if (SearchUtil.matches(value, searchValue = (String)searchValues.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String getUserHelp() {
        return "When the search value starts with ( and ends with ) the search value is considered a regular expression. When the search value consists of the 2 characters \"\" it will match the empty string. When the search value consists of the 4 characters null it will match when the object searched for is null. Otherwise the search value is considered a case insensitive wildcard search using * as the wildcard character (if the search value starts [ and ends with ] the search value is considered case sensitive) (if the search value doesn't contain the wildcard character it is interpreted as having a wildcard at the beginning and the end). In wildcard mode and regular expression mode the null object equals the empty string. The toString() method will be called on the object the search value is matched against.";
    }

    public static boolean matches(Object value, String query) {
        if (query != null && !"".equals(query)) {
            if (query.startsWith("(") && query.endsWith(")")) {
                if (value == null) {
                    value = "";
                }
                if (!value.toString().matches(query)) {
                    return false;
                }
            } else if (query.equals("null")) {
                if (value != null) {
                    return false;
                }
            } else if (query.equals("\"\"")) {
                if (value == null || !value.toString().equals("")) {
                    return false;
                }
            } else {
                boolean caseInsensitive = true;
                if (query.startsWith("[") && query.endsWith("]")) {
                    query = query.substring(1, query.length() - 1);
                    caseInsensitive = false;
                }
                if (query.indexOf(42) == -1) {
                    query = "*" + query + "*";
                }
                String valueAsString = value == null ? "" : value.toString();
                if (caseInsensitive) {
                    query = query.toLowerCase();
                    valueAsString = valueAsString.toLowerCase();
                }
                boolean queryStartsWithWildcard = query.startsWith("*");
                boolean queryEndsWithWildcard = query.endsWith("*");
                int j = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(query, "*");
                while (stringTokenizer.hasMoreTokens()) {
                    String token = stringTokenizer.nextToken();
                    if (!queryStartsWithWildcard) {
                        if (!valueAsString.startsWith(token)) {
                            return false;
                        }
                        queryStartsWithWildcard = true;
                        continue;
                    }
                    if (!queryEndsWithWildcard && !stringTokenizer.hasMoreTokens()) {
                        if (valueAsString.substring(j).endsWith(token)) continue;
                        return false;
                    }
                    if (token.length() == 0) continue;
                    if (j + token.length() > valueAsString.length()) {
                        return false;
                    }
                    if ((j = valueAsString.indexOf(token, j)) == -1) {
                        return false;
                    }
                    j += token.length();
                }
            }
        }
        return true;
    }
}

