/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xpath.XPathEvaluator;
import nl.nn.testtool.util.DummyOutputStream;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    private static final XPathEvaluator xpathEvaluator = new XPathEvaluator();

    public static XPathExpression createXPathExpression(String xpath) throws XPathExpressionException {
        return xpathEvaluator.compile(xpath);
    }

    public static Source createXmlSourceFromString(String xml) {
        StringReader stringReader = new StringReader(xml);
        return new StreamSource(stringReader);
    }

    public static boolean isXml(String xml) {
        InputSource inputSource = new InputSource(new StringReader(xml));
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        try {
            factory.newSAXParser().parse(inputSource, new DefaultHandler());
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        return true;
    }

    public static TransformerFactory getTransformerFactory() {
        return new TransformerFactoryImpl();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    public static String nodeToString(Node node) {
        Transformer transformer = XmlUtil.getTransformerFactory().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static Node stringToNode(String string) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtil.getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes())).getDocumentElement();
    }

    static {
        Configuration configuration = xpathEvaluator.getConfiguration();
        DummyOutputStream dummyOutputStream = new DummyOutputStream(configuration.getStandardErrorOutput());
        configuration.setStandardErrorOutput(new PrintStream(dummyOutputStream));
    }
}

