/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import nl.nn.testtool.web.BaseRewritingServletOutputStream;

public class AngularServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String artifactId;
    private String version = "";

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = "/" + version;
    }

    protected void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(response){

            public void sendError(int sc) throws IOException {
                if (sc == 404) {
                    try {
                        AngularServlet.this.includeWebJarAsset(request, response, true);
                    }
                    catch (ServletException e) {
                        super.sendError(500, "Got exception reading index.html for " + AngularServlet.this.artifactId + ": " + e.getMessage());
                    }
                } else {
                    super.sendError(sc);
                }
            }
        };
        this.includeWebJarAsset(request, (HttpServletResponse)responseWrapper, false);
    }

    private void includeWebJarAsset(HttpServletRequest request, HttpServletResponse response, boolean forceIndexHtml) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.endsWith("/") || forceIndexHtml) {
            pathInfo = "/index.html";
        }
        if ("/index.html".equals(pathInfo)) {
            String path = request.getContextPath() + request.getServletPath();
            final String base = path.equals("") ? "/" : (!path.endsWith("/") ? path + "/" : path);
            response = new HttpServletResponseWrapper((HttpServletResponse)response){

                public ServletOutputStream getOutputStream() throws IOException {
                    BaseRewritingServletOutputStream baseRewritingServletOutputStream = new BaseRewritingServletOutputStream(super.getOutputStream(), base);
                    return baseRewritingServletOutputStream;
                }
            };
        }
        String webJarsBase = "/webjars/";
        final String webJarsRequestURI = pathInfo.startsWith("/webjars/") ? pathInfo : "/webjars/" + this.artifactId + this.version + pathInfo;
        String[] tokens = webJarsRequestURI.split("/");
        String filename = tokens[tokens.length - 1];
        String mimeType = this.getServletContext().getMimeType(filename);
        response.setContentType(mimeType != null ? mimeType : "application/octet-stream");
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

            public String getServletPath() {
                return "/webjars/";
            }

            public String getRequestURI() {
                return webJarsRequestURI;
            }
        };
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(webJarsRequestURI);
        requestDispatcher.include((ServletRequest)wrapper, (ServletResponse)response);
    }
}

