/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<Pattern, ConfigurationPart> configuration = new HashMap<Pattern, ConfigurationPart>();

    public void setChangeReportGeneratorEnabledRoles(List<String> changeReportGeneratorEnabledRoles) {
        log.info("Set change report generator enabled roles");
        this.addConfigurationPart("POST/testtool$", changeReportGeneratorEnabledRoles);
    }

    public void setRerunRoles(List<String> rerunRoles) {
        log.info("Set rerun roles");
        this.addConfigurationPart("POST/runner/run/.*", rerunRoles);
    }

    public void setLadybugApiRoles(Map<String, List<String>> ladybugApiRoles) {
        log.info("Set Ladybug api roles");
        for (String path : ladybugApiRoles.keySet()) {
            this.addConfigurationPart(path, ladybugApiRoles.get(path));
        }
    }

    private void addConfigurationPart(String path, List<String> roles) {
        ConfigurationPart configurationPart = new ConfigurationPart(path, roles);
        log.debug("Add configuration part [" + configurationPart.toString() + "]");
        this.configuration.put(configurationPart.getPattern(), configurationPart);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getSecurityContext().getUserPrincipal() == null) {
            return;
        }
        if (this.configuration.size() != 0) {
            String path = requestContext.getUriInfo().getPath().toLowerCase();
            ConfigurationPart mostSpecificConfigurationPart = null;
            for (Pattern pattern : this.configuration.keySet()) {
                ConfigurationPart configurationPart = this.configuration.get(pattern);
                boolean pathMatches = pattern.matcher(path).matches();
                boolean isMostSpecificConfigurationPartNull = mostSpecificConfigurationPart == null;
                boolean isConfigurationPartMoreSpecific = isMostSpecificConfigurationPartNull || mostSpecificConfigurationPart.getSpecificity() < configurationPart.getSpecificity();
                boolean configurationPartContainsMethod = this.configuration.get(pattern).containsMethod(requestContext.getMethod());
                if (!pathMatches || !isMostSpecificConfigurationPartNull && !isConfigurationPartMoreSpecific || !configurationPartContainsMethod) continue;
                mostSpecificConfigurationPart = configurationPart;
            }
            if (mostSpecificConfigurationPart == null) {
                return;
            }
            for (String role : mostSpecificConfigurationPart.getRoles()) {
                if (!requestContext.getSecurityContext().isUserInRole(role)) continue;
                return;
            }
        }
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    private static class ConfigurationPart {
        private Set<String> methods;
        private Pattern pattern;
        private int specificity;
        private List<String> roles;

        ConfigurationPart(String methodsAndPathPattern, List<String> roles) {
            int firstSlash = methodsAndPathPattern.indexOf(47);
            String[] methods = methodsAndPathPattern.substring(0, firstSlash).split(",");
            if (methods.length != 0 && !methods[0].equals("")) {
                for (int i = 0; i < methods.length; ++i) {
                    methods[i] = methods[i].toLowerCase();
                }
                this.methods = new HashSet<String>(Arrays.asList(methods));
            }
            String regex = methodsAndPathPattern.substring(firstSlash + 1);
            this.specificity = (int)regex.chars().filter(ch -> ch == 47).count();
            this.pattern = Pattern.compile(regex);
            this.roles = roles == null ? new ArrayList(0) : roles;
        }

        public boolean containsMethod(String method) {
            return this.methods == null || this.methods.contains(method.toLowerCase());
        }

        public String toString() {
            return "Methods: \"" + this.methods + "\", Pattern: \"" + this.pattern + "\", Roles: " + this.roles.toString();
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public List<String> getRoles() {
            return this.roles;
        }
    }
}

