/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web.api;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import nl.nn.testtool.SecurityContext;
import nl.nn.testtool.web.api.ApiException;
import org.springframework.context.ApplicationContext;

public abstract class ApiBase
implements SecurityContext {
    protected static ApplicationContext applicationContext;
    @Context
    protected HttpServletRequest httpRequest;

    protected Object getBeanObject(String beanName) {
        if (applicationContext == null) {
            throw new ApiException("Api could not access the ladybug context.");
        }
        Object bean = applicationContext.getBean(beanName);
        if (bean == null) {
            throw new ApiException("Could not retrieve the requested bean [" + beanName + "]");
        }
        return bean;
    }

    protected <T> T getBean(String beanName) {
        try {
            return (T)this.getBeanObject(beanName);
        }
        catch (ClassCastException e) {
            throw new ApiException("Could not cast the bean to required class.", e);
        }
    }

    protected void setSessionAttr(String key, Object value) {
        this.httpRequest.getSession().setAttribute(key, value);
    }

    protected <T> T getSessionAttr(String key) {
        return this.getSessionAttr(key, true);
    }

    protected <T> T getSessionAttr(String key, boolean throwException) {
        Object object = this.httpRequest.getSession().getAttribute(key);
        if (object == null && throwException) {
            throw new ApiException("No session attribute with name [" + key + "] found.");
        }
        return (T)object;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.httpRequest.getUserPrincipal();
    }

    @Override
    public boolean isUserInRoles(List<String> roles) {
        if (this.getUserPrincipal() == null) {
            return true;
        }
        for (String role : roles) {
            if (!this.httpRequest.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean mapContainsOnly(Map<String, ?> map, String[] mandatory, String[] optional) {
        int count = 0;
        if (mandatory != null) {
            for (String field : mandatory) {
                if (map.containsKey(field)) continue;
                return false;
            }
            count = mandatory.length;
        }
        if (optional != null) {
            for (String field : optional) {
                if (!map.containsKey(field)) continue;
                ++count;
            }
        }
        return map.size() == count;
    }

    public static void setApplicationContext(ApplicationContext context) {
        applicationContext = context;
    }
}

