/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.web.api.ApiBase;

@Path(value="/metadata")
public class MetadataApi
extends ApiBase {
    private TestTool testTool;

    @GET
    @Path(value="/{storage}/")
    @Produces(value={"application/json"})
    public Response getMetadataList(@PathParam(value="storage") String storageName, @QueryParam(value="metadataNames") ArrayList<String> metadataNames, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="filterHeader") String filterHeader, @DefaultValue(value="(.*)") @QueryParam(value="filter") String filterParam, @Context UriInfo uriInfo) {
        ArrayList<String> searchValues = new ArrayList<String>();
        for (String field : metadataNames) {
            if (filterHeader.equals(field)) {
                searchValues.add(filterParam);
                continue;
            }
            searchValues.add(null);
        }
        try {
            Storage storage = this.testTool.getStorage(storageName);
            List<List<Object>> records = storage.getMetadata(limit, metadataNames, searchValues, 2);
            ArrayList metadata = new ArrayList();
            for (List<Object> record : records) {
                LinkedHashMap<String, String> metadataItem = new LinkedHashMap<String, String>();
                metadataItem.put("storageId", record.get(0).toString());
                for (int i = 1; i < metadataNames.size(); ++i) {
                    String value = null;
                    if (record.get(i) != null) {
                        value = record.get(i).toString();
                    }
                    metadataItem.put(metadataNames.get(i), value);
                }
                metadata.add(metadataItem);
            }
            return Response.ok().entity(metadata).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not find metadata with limit [" + limit + "] and filter [" + filterParam + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @GET
    @Path(value="/{storage}/userHelp")
    public Response getUserHelp(@PathParam(value="storage") String storageName, @QueryParam(value="metadataNames") ArrayList<String> metadataNames) {
        try {
            LinkedHashMap<String, String> userHelp = new LinkedHashMap<String, String>();
            Storage storage = this.testTool.getStorage(storageName);
            for (String field : metadataNames) {
                userHelp.put(field, storage.getUserHelp(field));
            }
            return Response.ok().entity(userHelp).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not find user help - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @GET
    @Path(value="/{storage}/count")
    @Produces(value={"application/json"})
    public Response getMetadataCount(@PathParam(value="storage") String storageName) {
        try {
            Storage storage = this.testTool.getStorage(storageName);
            return Response.ok().entity((Object)storage.getSize()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not find metadata count - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }
}

