/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web.api;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.echo2.test.TestComponent;
import nl.nn.testtool.echo2.util.Upload;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.transform.ReportXmlTransformer;
import nl.nn.testtool.util.Export;
import nl.nn.testtool.util.ExportResult;
import nl.nn.testtool.web.api.ApiBase;
import nl.nn.testtool.web.api.ApiException;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ReportApi
extends ApiBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TestTool testTool;
    private ReportXmlTransformer reportXmlTransformer;

    @GET
    @Path(value="/report/{storage}/{storageId}")
    @Produces(value={"application/json"})
    public Response getReport(@PathParam(value="storage") String storageName, @PathParam(value="storageId") int storageId, @QueryParam(value="xml") @DefaultValue(value="false") boolean xml, @QueryParam(value="globalTransformer") @DefaultValue(value="false") boolean globalTransformer) {
        try {
            Storage storage = this.testTool.getStorage(storageName);
            Report report = this.getReport(storage, storageId);
            if (report == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find report with id [" + storageId + "]")).build();
            }
            if (globalTransformer && this.reportXmlTransformer != null) {
                report.setGlobalReportXmlTransformer(this.reportXmlTransformer);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("report", report);
            map.put("xml", report.toXml());
            return Response.ok(map).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Exception while getting report [" + storageId + "] from storage [" + storageName + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @GET
    @Path(value="/report/{storage}/")
    @Produces(value={"application/json"})
    public Response getReports(@PathParam(value="storage") String storageName, @QueryParam(value="storageIds") ArrayList<Integer> storageIds, @QueryParam(value="xml") @DefaultValue(value="false") boolean xml, @QueryParam(value="globalTransformer") @DefaultValue(value="false") boolean globalTransformer) {
        try {
            Storage storage = this.testTool.getStorage(storageName);
            HashMap map = new HashMap();
            for (int storageId : storageIds) {
                Report report = this.getReport(storage, storageId);
                if (report == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find report with id [" + storageId + "]")).build();
                }
                if (globalTransformer && this.reportXmlTransformer != null) {
                    report.setGlobalReportXmlTransformer(this.reportXmlTransformer);
                }
                HashMap<String, Object> reportMap = new HashMap<String, Object>(1);
                reportMap.put("report", report);
                reportMap.put("xml", report.toXml());
                map.put(storageId, reportMap);
            }
            return Response.ok(map).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Exception while getting report [" + storageIds + "] from storage [" + storageName + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @DELETE
    @Path(value="/report/{storage}/{storageId}")
    public Response deleteReport(@PathParam(value="storage") String storageName, @PathParam(value="storageId") int storageId) {
        Storage storage = this.testTool.getStorage(storageName);
        if (!(storage instanceof CrudStorage)) {
            String msg = "Given storage [" + storageName + "] does not implement delete function.";
            log.warn(msg);
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)msg).build();
        }
        try {
            Report report = this.getReport(storage, storageId);
            if (report == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find report with storage id [" + storageId + "]")).build();
            }
            ((CrudStorage)storage).delete(report);
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not delete report with storageId [" + storageId + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/report/latest/{storage}/{numberOfReports}")
    public Response getLatestReports(@PathParam(value="storage") String storageName, @PathParam(value="numberOfReports") int number) {
        try {
            Storage storage = this.testTool.getStorage(storageName);
            List<List<Object>> metadata = storage.getMetadata(-1, Arrays.asList("storageId", "endTime"), Arrays.asList(null, null), 0);
            int amount = Math.min(metadata.size(), number);
            if (amount < 1) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Either the number of reports requested [" + number + "] and/or the size of reports available [" + metadata.size() + "] is 0")).build();
            }
            metadata.sort(Comparator.comparingLong(o -> (Long)o.get(1)));
            ArrayList<Report> reports = new ArrayList<Report>(amount);
            for (int i = 1; i <= amount; ++i) {
                reports.add(this.getReport(storage, (Integer)metadata.get(metadata.size() - i).get(0)));
            }
            return Response.ok(reports).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not retrieve latest [" + number + "] reports - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @POST
    @Path(value="/report/{storage}/{storageId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateReport(@PathParam(value="storage") String storageName, @PathParam(value="storageId") int storageId, Map<String, String> map) {
        String[] fields = new String[]{"name", "path", "variables", "description", "transformation", "checkpointId", "checkpointMessage", "stub"};
        if (map.isEmpty() || !this.mapContainsOnly(map, null, fields)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No new values or incorrect values have been given for report with storageId [" + storageId + "] - detailed error message - Values given are:\n" + map)).build();
        }
        try {
            String variables;
            Storage storage = this.testTool.getStorage(storageName);
            Report report = this.getReport(storage, storageId);
            if (report == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find report with storageId [" + storageId + "]")).build();
            }
            if (StringUtils.isNotEmpty((String)map.get("name"))) {
                report.setName(map.get("name"));
            }
            if (StringUtils.isNotEmpty((String)map.get("path"))) {
                report.setPath(TestComponent.normalizePath(map.get("path")));
            }
            if (StringUtils.isNotEmpty((String)map.get("description"))) {
                report.setDescription(map.get("description"));
            }
            if (StringUtils.isNotEmpty((String)map.get("transformation"))) {
                report.setTransformation(map.get("transformation"));
            }
            if ((variables = map.get("variables")) != null && !variables.equals(report.getVariableCsv())) {
                report.setVariableCsv(variables);
            }
            if (StringUtils.isNotEmpty((String)map.get("checkpointId"))) {
                if (StringUtils.isNotEmpty((String)map.get("stub"))) {
                    report.getCheckpoints().get(Integer.parseInt(map.get("checkpointId"))).setStub(Integer.parseInt(map.get("stub")));
                } else {
                    report.getCheckpoints().get(Integer.parseInt(map.get("checkpointId"))).setMessage(map.get("checkpointMessage"));
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            report.flushCachedXml();
            boolean storageUpdated = false;
            if (storage instanceof CrudStorage) {
                CrudStorage crudStorage = (CrudStorage)storage;
                crudStorage.update(report);
                storageUpdated = true;
            } else if (this.reportXmlTransformer != null) {
                report.setGlobalReportXmlTransformer(this.reportXmlTransformer);
            }
            result.put("xml", report.toXml());
            result.put("storageUpdated", storageUpdated);
            result.put("report", report);
            return Response.ok(result).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not apply transformation to report with storageId [" + storageId + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @GET
    @Path(value="/report/transformation/{storage}/{storageId}")
    @Produces(value={"application/json"})
    public Response getReportTransformation(@PathParam(value="storage") String storageName, @PathParam(value="storageId") int storageId) {
        try {
            Storage storage = this.testTool.getStorage(storageName);
            String transformation = this.getReport(storage, storageId).getTransformation();
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("transformation", transformation);
            return Response.ok(map).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not retrieve transformation of report with storageId [" + storageId + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @PUT
    @Path(value="/report/store/{storage}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response copyReport(@PathParam(value="storage") String storageName, Map<String, List<Integer>> sources) {
        Storage target = this.testTool.getStorage(storageName);
        HashMap<String, String> exceptions = new HashMap<String, String>();
        ArrayList<Report> reports = new ArrayList<Report>();
        for (String src : sources.keySet()) {
            try {
                Storage srcStorage = this.testTool.getStorage(src);
                for (int storageId : sources.get(src)) {
                    try {
                        Report report = this.getReport(srcStorage, storageId);
                        ((CrudStorage)target).store(report);
                        reports.add(report);
                    }
                    catch (Exception exception) {
                        exceptions.put(src + "_" + storageId, Arrays.toString(exception.getStackTrace()));
                        log.error("Could not copy the report. #Exceptions for request: " + exceptions, (Throwable)exception);
                    }
                }
            }
            catch (ApiException e) {
                exceptions.put(src, e.getMessage());
            }
        }
        if (exceptions.size() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Exceptions have been thrown when trying to copy report - detailed error message - Exceptions:\n" + exceptions)).build();
        }
        return Response.ok(reports).build();
    }

    @POST
    @Path(value="/report/upload/{storage}")
    @Produces(value={"text/html"})
    @Consumes(value={"multipart/form-data"})
    public Response uploadFile(@PathParam(value="storage") String storageName, @Multipart(value="file") Attachment attachment) {
        InputStream in;
        Storage storage = this.testTool.getStorage(storageName);
        if (!(storage instanceof CrudStorage)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Given storage [" + storage.getName() + "] is not a Crud Storage. Therefore no reports can be added externally.")).build();
        }
        CrudStorage crudStorage = (CrudStorage)storage;
        String filename = attachment.getContentDisposition().getParameter("filename");
        String errorMessage = Upload.upload(filename, in = (InputStream)attachment.getObject(InputStream.class), crudStorage, log);
        if (StringUtils.isEmpty((String)errorMessage)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
    }

    @POST
    @Path(value="/report/upload")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response getFileReport(@Multipart(value="file") Attachment attachment) {
        InputStream in;
        nl.nn.testtool.storage.memory.Storage storage = new nl.nn.testtool.storage.memory.Storage();
        String filename = attachment.getContentDisposition().getParameter("filename");
        String errorMessage = Upload.upload(filename, in = (InputStream)attachment.getObject(InputStream.class), storage, log);
        if (StringUtils.isNotEmpty((String)errorMessage)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        try {
            Iterator storageIdsIterator = storage.getStorageIds().iterator();
            ArrayList<Report> reports = new ArrayList<Report>(storage.getStorageIds().size());
            while (storageIdsIterator.hasNext()) {
                Report report = this.getReport(storage, (Integer)storageIdsIterator.next());
                reports.add(report);
            }
            return Response.ok(reports).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not retrieve parsed reports from in-memory storage - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @GET
    @Path(value="/report/download/{storage}/{exportReport}/{exportReportXml}")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public Response downloadFile(@PathParam(value="storage") String storageName, @PathParam(value="exportReport") String exportReportParam, @PathParam(value="exportReportXml") String exportReportXmlParam, @QueryParam(value="id") List<Integer> storageIds) {
        Storage storage = this.testTool.getStorage(storageName);
        if (storageIds == null || storageIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No storage ids have been provided").build();
        }
        boolean exportReport = exportReportParam.equalsIgnoreCase("true") || exportReportParam.equals("1");
        boolean exportReportXml = exportReportXmlParam.equalsIgnoreCase("true") || exportReportXmlParam.equals("1");
        try {
            ExportResult export;
            if (storageIds.size() == 1) {
                Report report = this.getReport(storage, storageIds.get(0));
                export = Export.export(report, exportReport, exportReportXml);
            } else {
                export = Export.export(storage, storageIds, exportReport, exportReportXml);
            }
            Response.ResponseBuilder response = Response.ok((Object)export.getTempFile(), (String)"application/octet-stream");
            response.header("Content-Disposition", (Object)("attachment; filename=" + export.getSuggestedFilename()));
            return response.build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Exception while requesting reports with ids [" + storageIds + "] from the storage. - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @PUT
    @Path(value="/report/move/{storage}/{storageId}")
    @Consumes(value={"application/json"})
    public Response updatePath(@PathParam(value="storage") String storageName, @PathParam(value="storageId") int storageId, Map<String, String> map) {
        CrudStorage storage = (CrudStorage)this.testTool.getStorage(storageName);
        String path = map.get("path");
        String action = map.get("action");
        if (StringUtils.isEmpty((String)action) || StringUtils.isEmpty((String)path)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"[action] and [path] are both required in the request body.").build();
        }
        try {
            Report original = this.getReport(storage, storageId);
            if ("copy".equalsIgnoreCase(action)) {
                Report clone = original.clone();
                clone.setPath(path);
                storage.store(clone);
            } else if ("move".equalsIgnoreCase(action)) {
                original.setPath(path);
                storage.update(original);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Action parameter can only be either [copy] or [move]").build();
            }
            return Response.ok().build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Storage exception with storage id [" + storageId + "] in storage [" + storageName + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
        catch (CloneNotSupportedException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Cloning exception for report with storage id [" + storageId + "] in storage [" + storageName + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @POST
    @Path(value="/report/move/{storageName}/{storageId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cloneReport(@QueryParam(value="storageId") int storageId, @QueryParam(value="storageName") String storageName, Map<String, String> map) {
        Report original;
        CrudStorage storage = (CrudStorage)this.testTool.getStorage(storageName);
        try {
            original = this.getReport(storage, storageId);
            String previousMessage = original.getInputCheckpoint().getMessage();
            boolean force = "true".equalsIgnoreCase(map.getOrDefault("force", "false")) || "1".equalsIgnoreCase(map.getOrDefault("force", "false"));
            original.getInputCheckpoint().setMessage(map.get("message"));
            if (!original.getInputCheckpoint().containsVariables() && !force) {
                original.getInputCheckpoint().setMessage(previousMessage);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No variables found in input message; press again to confirm").build();
            }
        }
        catch (StorageException e) {
            log.error("Exception while cloning the report", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Report could not be found. - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
        Scanner scanner = new Scanner(map.get("csv"));
        String firstLine = null;
        boolean originalSet = false;
        ArrayList<String> exceptions = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            if (StringUtils.isEmpty((String)nextLine) && nextLine.startsWith("#")) continue;
            if (firstLine == null) {
                firstLine = nextLine;
                continue;
            }
            try {
                if (originalSet) {
                    Report clone = original.clone();
                    clone.setVariableCsvWithoutException(firstLine + "\n" + nextLine);
                    storage.store(clone);
                    continue;
                }
                originalSet = true;
                original.setVariableCsvWithoutException(firstLine + "\n" + nextLine);
                storage.update(original);
            }
            catch (CloneNotSupportedException | StorageException e) {
                exceptions.add(e.getMessage() + " Caused by: " + e.getCause() + " For line: [" + nextLine + "]");
            }
        }
        scanner.close();
        return Response.ok().entity(exceptions).build();
    }

    public Report getReport(Storage storage, Integer storageId) throws StorageException {
        Report report = storage.getReport(storageId);
        if (report != null) {
            report.setTestTool(this.testTool);
        }
        return report;
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }
}

