/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web.api;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.run.ReportRunner;
import nl.nn.testtool.run.RunResult;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.transform.ReportXmlTransformer;
import nl.nn.testtool.web.api.ApiBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/runner")
public class RunApi
extends ApiBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TestTool testTool;
    private ReportXmlTransformer reportXmlTransformer;

    @POST
    @Path(value="/run/{testStorageName}/{debugStorageName}/{storageId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response runReport(@PathParam(value="storageId") int storageId, @PathParam(value="testStorageName") String testStorageName, @PathParam(value="debugStorageName") String debugStorageName) {
        Storage testStorage = this.testTool.getStorage(testStorageName);
        ArrayList<String> exceptions = new ArrayList<String>();
        ReportRunner runner = this.getRunner(this.testTool.getStorage(debugStorageName));
        HashMap<Object, Object> result = new HashMap();
        String exception = null;
        HashMap<Integer, Report> reranReports = (HashMap<Integer, Report>)this.getSessionAttr("reranReports", false);
        if (reranReports == null) {
            reranReports = new HashMap<Integer, Report>();
            this.setSessionAttr("reranReports", reranReports);
        }
        try {
            Report report = testStorage.getReport(storageId);
            if (report != null) {
                report.setTestTool(this.testTool);
                reranReports.put(storageId, report);
                exception = runner.run(Collections.singletonList(report), true, true);
                RunResult runResult = runner.getResults().get(storageId);
                if (runResult.errorMessage != null) {
                    exceptions.add(runResult.errorMessage);
                }
                Report runResultReport = runner.getRunResultReport(runResult.correlationId);
                result = this.extractRunResult(runResultReport, report.getStorageId(), reranReports, runner);
            }
        }
        catch (StorageException e) {
            exceptions.add("Exception for report in [testStorage] with storage id [" + storageId + "] - detailed error message -  " + e + Arrays.toString(e.getStackTrace()));
            e.printStackTrace();
        }
        if (exceptions.size() > 0) {
            String message = "Exceptions have been thrown, causing the related reports not to run. - detailed error message - Exceptions:\n" + String.join((CharSequence)". \n", exceptions);
            return Response.serverError().entity((Object)message).build();
        }
        if (exception != null) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)("Exception has been thrown, caused the related report not to run. - detailed error message - " + exception)).build();
        }
        return Response.ok(result).build();
    }

    private HashMap<String, Object> extractRunResult(Report runResultReport, int storageId, HashMap<Integer, Report> reranReports, ReportRunner runner) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        int stubbed = 0;
        boolean first = true;
        for (Checkpoint checkpoint : runResultReport.getCheckpoints()) {
            if (first) {
                first = false;
                continue;
            }
            if (!checkpoint.isStubbed()) continue;
            ++stubbed;
        }
        Report report = reranReports.get(storageId);
        report.setGlobalReportXmlTransformer(this.reportXmlTransformer);
        runResultReport.setGlobalReportXmlTransformer(this.reportXmlTransformer);
        res.put("stubbed", stubbed);
        res.put("total", runResultReport.getCheckpoints().size() - 1);
        res.put("previousTime", report.getEndTime() - report.getStartTime());
        res.put("currentTime", runResultReport.getEndTime() - runResultReport.getStartTime());
        res.put("equal", report.toXml(runner).equals(runResultReport.toXml(runner)));
        res.put("originalReport", report);
        res.put("runResultReport", runResultReport);
        res.put("originalXml", report.toXml(runner));
        res.put("runResultXml", runResultReport.toXml(runner));
        return res;
    }

    @PUT
    @Path(value="/replace/{debugStorage}/{storageId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response runReport(@PathParam(value="debugStorage") String storageName, @PathParam(value="storageId") int storageId) {
        try {
            Storage debugStorage = this.testTool.getStorage(storageName);
            ReportRunner reportRunner = this.getRunner(debugStorage);
            Report runResultReport = reportRunner.getRunResultReport(reportRunner.getResults().get((Object)Integer.valueOf((int)storageId)).correlationId);
            HashMap reranReports = (HashMap)this.getSessionAttr("reranReports", true);
            Report report = (Report)reranReports.get(storageId);
            log.debug("Replacing report [" + report.getStorage().getName() + ":" + report.getStorageId() + "] with [" + debugStorage.getName() + ":" + runResultReport.getStorageId() + "]");
            runResultReport.setTestTool(report.getTestTool());
            runResultReport.setName(report.getName());
            runResultReport.setDescription(report.getDescription());
            if (report.getCheckpoints().get(0).containsVariables()) {
                runResultReport.getCheckpoints().get(0).setMessage(report.getCheckpoints().get(0).getMessage());
            }
            runResultReport.setPath(report.getPath());
            runResultReport.setTransformation(report.getTransformation());
            runResultReport.setReportXmlTransformer(report.getReportXmlTransformer());
            runResultReport.setVariableCsvWithoutException(report.getVariableCsv());
            runResultReport.setStorageId(report.getStorageId());
            ((CrudStorage)report.getStorage()).update(runResultReport);
            reportRunner.getResults().remove(storageId);
            reranReports.remove(storageId);
            return Response.ok((Object)runResultReport).build();
        }
        catch (StorageException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Exception while replacing report with storage id [" + storageId + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @POST
    @Path(value="/reset")
    public Response resetAll() {
        Object sessionAttr = this.getSessionAttr("reportRunner", false);
        if (!(sessionAttr instanceof Map)) {
            this.setSessionAttr("reportRunner", new HashMap());
            return Response.ok().build();
        }
        Map map = (Map)sessionAttr;
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (val instanceof ReportRunner) {
                ReportRunner runner = (ReportRunner)val;
                runner.reset();
                continue;
            }
            map.remove(key);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/reset/{debugStorage}")
    public Response resetRunner(@PathParam(value="debugStorage") String storageName) {
        Storage storage = this.testTool.getStorage(storageName);
        ReportRunner runner = this.getRunner(storage);
        runner.reset();
        return Response.ok().build();
    }

    private ReportRunner getRunner(Storage debugStorage) {
        HashMap<Storage, ReportRunner> runners;
        Object sessionAttr = this.getSessionAttr("reportRunner", false);
        if (sessionAttr instanceof Map) {
            runners = (HashMap<Storage, ReportRunner>)sessionAttr;
        } else {
            runners = new HashMap<Storage, ReportRunner>();
            this.setSessionAttr("reportRunner", runners);
        }
        ReportRunner runner = (ReportRunner)runners.get(debugStorage);
        if (runner == null) {
            runner = new ReportRunner();
            runner.setTestTool(this.testTool);
            runner.setDebugStorage(debugStorage);
            runner.setSecurityContext(this);
            runners.put(debugStorage, runner);
        }
        return runner;
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }
}

