/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.web.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.filter.View;
import nl.nn.testtool.filter.Views;
import nl.nn.testtool.transform.ReportXmlTransformer;
import nl.nn.testtool.web.api.ApiBase;
import org.apache.commons.lang.StringUtils;

@Path(value="/testtool")
public class TestToolApi
extends ApiBase {
    private TestTool testTool;
    private ReportXmlTransformer reportXmlTransformer;
    private Views views;
    private String defaultTransformation;

    @PostConstruct
    public void init() {
        this.defaultTransformation = this.reportXmlTransformer.getXslt();
    }

    public String getDefaultTransformation() {
        return this.defaultTransformation;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("generatorEnabled", this.testTool.isReportGeneratorEnabled());
        map.put("estMemory", this.testTool.getReportsInProgressEstimatedMemoryUsage());
        map.put("regexFilter", this.testTool.getRegexFilter());
        map.put("reportsInProgress", this.testTool.getNumberOfReportsInProgress());
        map.put("stubStrategies", this.testTool.getStubStrategies());
        return Response.ok(map).build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response updateInfo(Map<String, String> map) {
        if (map.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No settings have been provided - detailed error message - The settings that have been provided are " + map)).build();
        }
        if (map.size() > 2) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Too many settings have been provided - detailed error message - The settings that have been provided are " + map)).build();
        }
        String generatorEnabled = map.remove("generatorEnabled");
        String regexFilter = map.remove("regexFilter");
        if (StringUtils.isNotEmpty((String)generatorEnabled)) {
            this.testTool.setReportGeneratorEnabled("1".equalsIgnoreCase(generatorEnabled) || "true".equalsIgnoreCase(generatorEnabled));
            this.testTool.sendReportGeneratorStatusUpdate();
        }
        if (StringUtils.isNotEmpty((String)regexFilter)) {
            this.testTool.setRegexFilter(regexFilter);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/in-progress/{index}")
    @Produces(value={"application/json"})
    public Response getReportsInProgress(@PathParam(value="index") int index) {
        if (index == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No progresses have been queried [" + index + "] and/or are available [" + this.testTool.getNumberOfReportsInProgress() + "]")).build();
        }
        try {
            Report report = this.testTool.getReportInProgress(index - 1);
            return Response.ok((Object)report).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not find report in progress with index [" + index + "] - detailed error message - " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @DELETE
    @Path(value="/in-progress/{index}")
    public Response deleteReportInProgress(@PathParam(value="index") int index) {
        if (index == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No progresses have been queried [" + index + "] or are available [" + this.testTool.getNumberOfReportsInProgress() + "]")).build();
        }
        try {
            this.testTool.removeReportInProgress(index - 1);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not find report in progress with index [" + index + "] :: " + e + Arrays.toString(e.getStackTrace()))).build();
        }
    }

    @POST
    @Path(value="/transformation/")
    @Consumes(value={"application/json"})
    public Response updateReportTransformation(Map<String, String> map) {
        String transformation = map.get("transformation");
        if (StringUtils.isEmpty((String)transformation)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No transformation has been provided").build();
        }
        this.reportXmlTransformer.setXslt(transformation);
        return Response.ok().build();
    }

    @GET
    @Path(value="/transformation/{defaultTransformation}")
    @Produces(value={"application/json"})
    public Response getReportTransformation(@PathParam(value="defaultTransformation") boolean defaultTransformation) {
        String transformation = defaultTransformation ? this.getDefaultTransformation() : this.reportXmlTransformer.getXslt();
        if (StringUtils.isEmpty((String)transformation)) {
            return Response.noContent().build();
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("transformation", transformation);
        return Response.ok(map).build();
    }

    @GET
    @Path(value="/views/")
    @Produces(value={"application/json"})
    public Response getViewsResponse() {
        HashMap response = new HashMap();
        for (View view : this.views) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("storageName", view.getStorage().getName());
            if (view == this.views.getDefaultView()) {
                map.put("defaultView", true);
            } else {
                map.put("defaultView", false);
            }
            map.put("metadataNames", view.getMetadataNames());
            response.put(view.getName(), map);
        }
        return Response.ok(response).build();
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }

    public void setViews(Views views) {
        this.views = views;
    }
}

