/*
 * Decompiled with CFR 0.152.
 */
package org.ibissource.maven;

import com.google.common.base.Strings;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="org.ibissource.maven.IbisLifecycleParticipant")
public class IbisLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    public static String MAVEN_WAR_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    public static String MAVEN_WAR_PLUGIN_ARTIFACT_ID = "maven-war-plugin";
    public static String IBIS_WAR_PLUGIN_GROUP_ID = "org.ibissource";
    public static String IBIS_WAR_PLUGIN_ARTIFACT_ID = "ibis-war-plugin";
    private Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        int skipped = 0;
        this.displayIafLogo();
        for (MavenProject project : session.getProjects()) {
            Plugin mavenWarPlugin;
            Plugin ibisWarPlugin = this.getIbisWarPlugin(project.getModel());
            if (ibisWarPlugin == null || (mavenWarPlugin = this.getMavenWarPlugin(project.getModel())) == null) continue;
            mavenWarPlugin.getExecutions().clear();
            PluginExecution execution = new PluginExecution();
            execution.setId("injected-ibis-war-plugin");
            execution.getGoals().add("war");
            execution.setPhase("package");
            execution.setConfiguration(ibisWarPlugin.getConfiguration());
            ibisWarPlugin.getExecutions().add(execution);
            ++skipped;
        }
        if (skipped > 0) {
            this.logger.info("Replaced (" + skipped + ") execution(s) of " + MAVEN_WAR_PLUGIN_ARTIFACT_ID + " with " + IBIS_WAR_PLUGIN_ARTIFACT_ID);
        } else {
            this.logger.info("No executions of " + MAVEN_WAR_PLUGIN_ARTIFACT_ID + " were replaced");
        }
    }

    private void displayIafLogo() {
        this.logger.info("  _____            ______ ");
        this.logger.info(" |_   _|    /\\    |  ____|");
        this.logger.info("   | |     /  \\   | |__   ");
        this.logger.info("   | |    / /\\ \\  |  __|  ");
        this.logger.info("  _| |_  / ____ \\ | |     ");
        this.logger.info(" |_____|/_/    \\_\\|_|     ");
        this.logger.info("            Ibis War Plugin");
        this.logger.info(" ");
    }

    protected Plugin getMavenWarPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getMavenWarPluginFromContainer((PluginContainer)model.getBuild());
        }
        return null;
    }

    protected Plugin getIbisWarPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getIbisWarPluginFromContainer((PluginContainer)model.getBuild());
        }
        return null;
    }

    protected Plugin getMavenWarPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(MAVEN_WAR_PLUGIN_GROUP_ID, MAVEN_WAR_PLUGIN_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getIbisWarPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(IBIS_WAR_PLUGIN_GROUP_ID, IBIS_WAR_PLUGIN_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getPluginByGAFromContainer(String groupId, String artifactId, PluginContainer pluginContainer) {
        Plugin result = null;
        for (Plugin plugin : pluginContainer.getPlugins()) {
            this.logger.debug("Found plugin [" + plugin.getArtifactId() + "]");
            if (!Strings.nullToEmpty((String)groupId).equals(Strings.nullToEmpty((String)plugin.getGroupId())) || !Strings.nullToEmpty((String)artifactId).equals(Strings.nullToEmpty((String)plugin.getArtifactId()))) continue;
            if (result != null) {
                throw new IllegalStateException("The build contains multiple versions of plugin " + groupId + ":" + artifactId);
            }
            result = plugin;
        }
        return result;
    }
}

