/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.dispatcher;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Set;
import nl.nn.adapterframework.dispatcher.DispatcherException;
import nl.nn.adapterframework.dispatcher.DispatcherManager;
import nl.nn.adapterframework.dispatcher.PassThroughProxyHandler;
import nl.nn.adapterframework.dispatcher.RequestProcessor;
import nl.nn.adapterframework.dispatcher.RequestProcessorException;

class DispatcherManagerImpl
implements DispatcherManager {
    private static final boolean DEBUG = true;
    private static DispatcherManager instance = null;
    private HashMap<String, RequestProcessor> requestProcessorMap = new HashMap();

    static DispatcherManager getInstance(ClassLoader classLoader) throws DispatcherException {
        DispatcherManager result = null;
        ClassLoader parentclassLoader = classLoader.getParent();
        if (parentclassLoader != null && (result = DispatcherManagerImpl.getInstance(parentclassLoader)) == null) {
            ClassLoader myClassLoader = DispatcherManagerImpl.class.getClassLoader();
            try {
                Class<?> classInstance = parentclassLoader.loadClass(DispatcherManagerImpl.class.getName());
                Method getInstanceMethod = classInstance.getDeclaredMethod("getInstance", new Class[0]);
                Object otherDispatcherManager = getInstanceMethod.invoke(null, new Object[0]);
                result = (DispatcherManager)Proxy.newProxyInstance(myClassLoader, new Class[]{DispatcherManager.class}, (InvocationHandler)new PassThroughProxyHandler(otherDispatcherManager));
                System.out.println("DispatcherManagerImpl INFO  created DispatcherManager using ClassLoader [" + parentclassLoader.getClass().getName() + "] that is parent of [" + classLoader.getClass().getName() + "]");
            }
            catch (Exception e) {
                System.out.println("DispatcherManagerImpl DEBUG " + e.getClass().getName() + " when trying to load DispatcherManager using ClassLoader [" + parentclassLoader.getClass().getName() + "] that is parent of [" + classLoader.getClass().getName() + "]: " + e.getMessage());
                return null;
            }
        }
        return result;
    }

    static synchronized DispatcherManager getInstance() throws DispatcherException {
        if (instance == null) {
            ClassLoader myClassLoader = DispatcherManagerImpl.class.getClassLoader();
            if (myClassLoader != null) {
                instance = DispatcherManagerImpl.getInstance(myClassLoader);
            } else {
                System.out.println("DispatcherManagerImpl WARN  could not obtain ClassLoader for [" + DispatcherManagerImpl.class.getName() + "], instantiated DispatcherManager might be too low in class path tree (not on a common branch)");
            }
            if (instance == null) {
                instance = new DispatcherManagerImpl();
            }
        }
        return instance;
    }

    private DispatcherManagerImpl() {
    }

    @Override
    public String processRequest(String serviceName, String message) throws DispatcherException, RequestProcessorException {
        return this.processRequest(serviceName, null, message, null);
    }

    @Override
    public String processRequest(String serviceName, String message, HashMap requestContext) throws DispatcherException, RequestProcessorException {
        return this.processRequest(serviceName, null, message, requestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processRequest(String serviceName, String correlationId, String message, HashMap requestContext) throws DispatcherException, RequestProcessorException {
        RequestProcessor listener = null;
        HashMap<String, RequestProcessor> hashMap = this.requestProcessorMap;
        synchronized (hashMap) {
            listener = this.requestProcessorMap.get(serviceName);
        }
        if (listener == null) {
            throw new DispatcherException("no RequestProcessor registered for [" + serviceName + "]");
        }
        ClassLoader callersClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
            String string = listener.processRequest(correlationId, message, requestContext);
            Thread.currentThread().setContextClassLoader(callersClassLoader);
            return string;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(callersClassLoader);
                throw throwable;
            }
            catch (Throwable t) {
                throw new RequestProcessorException("RequestProcessor [" + serviceName + "] caught exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String serviceName, RequestProcessor listener) throws DispatcherException {
        HashMap<String, RequestProcessor> hashMap = this.requestProcessorMap;
        synchronized (hashMap) {
            this.requestProcessorMap.put(serviceName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String serviceName) {
        HashMap<String, RequestProcessor> hashMap = this.requestProcessorMap;
        synchronized (hashMap) {
            if (this.requestProcessorMap.containsKey(serviceName)) {
                this.requestProcessorMap.remove(serviceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredServices() {
        HashMap<String, RequestProcessor> hashMap = this.requestProcessorMap;
        synchronized (hashMap) {
            return this.requestProcessorMap.keySet();
        }
    }
}

