/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.dispatcher;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import nl.nn.adapterframework.dispatcher.DispatcherException;
import nl.nn.adapterframework.dispatcher.DispatcherManager;
import nl.nn.adapterframework.dispatcher.DllDispatcherManagerInterface;
import nl.nn.adapterframework.dispatcher.PassThroughProxyHandler;
import nl.nn.adapterframework.dispatcher.RequestProcessor;
import nl.nn.adapterframework.dispatcher.RequestProcessorException;

public class DllDispatcherManagerImpl
implements DispatcherManager {
    private DllDispatcherManagerInterface DllInstance;
    private static final String PROPERTYPREFIX = "ibis-servicedispatcher";
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("ibis-servicedispatcher.debug", "false"));
    private static final String dlls = System.getProperty("ibis-servicedispatcher.dlls", "");
    private Set<String> availableServices = new HashSet<String>();
    private static DispatcherManager instance = null;

    static DispatcherManager getInstance(ClassLoader classLoader) throws DispatcherException {
        DispatcherManager result = null;
        ClassLoader parentclassLoader = classLoader.getParent();
        if (parentclassLoader != null && (result = DllDispatcherManagerImpl.getInstance(parentclassLoader)) == null) {
            ClassLoader myClassLoader = DllDispatcherManagerImpl.class.getClassLoader();
            try {
                Class<?> classInstance = parentclassLoader.loadClass(DllDispatcherManagerImpl.class.getName());
                Method getInstanceMethod = classInstance.getDeclaredMethod("getInstance", new Class[0]);
                Object otherDispatcherManager = getInstanceMethod.invoke(null, new Object[0]);
                result = (DispatcherManager)Proxy.newProxyInstance(myClassLoader, new Class[]{DispatcherManager.class}, (InvocationHandler)new PassThroughProxyHandler(otherDispatcherManager));
                if (DEBUG) {
                    System.out.println("DllDispatcherManagerImpl INFO  created DispatcherManager using ClassLoader [" + parentclassLoader.getClass().getName() + "] that is parent of [" + classLoader.getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.out.println("DllDispatcherManagerImpl DEBUG " + e.getClass().getName() + " when trying to load DispatcherManager using ClassLoader [" + parentclassLoader.getClass().getName() + "] that is parent of [" + classLoader.getClass().getName() + "]: " + e.getMessage());
                }
                return null;
            }
        }
        return result;
    }

    static synchronized DispatcherManager getInstance() throws DispatcherException {
        if (instance == null) {
            ClassLoader myClassLoader = DllDispatcherManagerImpl.class.getClassLoader();
            if (myClassLoader != null) {
                instance = DllDispatcherManagerImpl.getInstance(myClassLoader);
            } else {
                System.out.println("DllDispatcherManagerImpl WARN  could not obtain ClassLoader for [" + DllDispatcherManagerImpl.class.getName() + "], instantiated DispatcherManager might be too low in class path tree (not on a common branch)");
            }
            if (instance == null) {
                instance = new DllDispatcherManagerImpl();
            }
        }
        return instance;
    }

    private DllDispatcherManagerImpl() throws DispatcherException {
        StringTokenizer st;
        try {
            Class<?> dll = Class.forName("DllDispatcherManager");
            this.DllInstance = (DllDispatcherManagerInterface)dll.newInstance();
            if (dlls.isEmpty()) {
                throw new DispatcherException("No DLL found, has the property [ibis-servicedispatcher.dlls] been set?");
            }
            st = new StringTokenizer(dlls, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                File lib = new File(path);
                String absPath = lib.getAbsolutePath();
                absPath = absPath.replace(lib.getName(), "");
                if (!lib.isFile()) {
                    throw new DispatcherException("File [" + lib.getName() + "] not found in path [" + absPath + "]");
                }
                this.DllInstance.registerDll(lib.getAbsolutePath());
                if (!DEBUG) continue;
                System.out.println("Registered dll [" + lib.getName() + "] from path [" + absPath + "]");
            }
        }
        catch (Exception e) {
            throw new DispatcherException("Failed to initialize DllDispatcherManager", e);
        }
        String services = this.DllInstance.getServices();
        if (!services.isEmpty()) {
            st = new StringTokenizer(services, ",");
            while (st.hasMoreTokens()) {
                this.register(st.nextToken());
            }
        } else {
            throw new DispatcherException("Successfully loaded DllDispatcherManager, but no services were found!");
        }
    }

    @Override
    public String processRequest(String serviceName, String message) throws DispatcherException, RequestProcessorException {
        return this.processRequest(serviceName, null, message, null);
    }

    @Override
    public String processRequest(String serviceName, String message, HashMap requestContext) throws DispatcherException, RequestProcessorException {
        return this.processRequest(serviceName, null, message, requestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processRequest(String serviceName, String correlationId, String message, HashMap requestContext) throws DispatcherException, RequestProcessorException {
        try {
            boolean registeredService = false;
            Set<String> set = this.availableServices;
            synchronized (set) {
                registeredService = this.availableServices.contains(serviceName);
            }
            if (!registeredService) {
                throw new DispatcherException("no service registered for [" + serviceName + "]");
            }
            return this.DllInstance.processRequest(serviceName, correlationId, message);
        }
        catch (Exception e) {
            throw new DispatcherException("Error while processing service [" + serviceName + "]", e);
        }
    }

    @Override
    public void register(String serviceName, RequestProcessor listener) throws DispatcherException {
        this.register(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String serviceName) {
        Set<String> set = this.availableServices;
        synchronized (set) {
            this.availableServices.add(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String serviceName) {
        Set<String> set = this.availableServices;
        synchronized (set) {
            this.availableServices.remove(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredServices() {
        Set<String> set = this.availableServices;
        synchronized (set) {
            return this.availableServices;
        }
    }
}

