/*
 * Decompiled with CFR 0.152.
 */
package org.ic4j.websocket;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.ic4j.agent.ReplicaTransport;
import org.ic4j.websocket.WebsocketError;
import org.ic4j.websocket.WebsocketTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class JavaxWebsocketTransport
extends WebsocketTransport {
    ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new CBORFactory()).registerModule((Module)new Jdk8Module());
    Session userSession = null;
    static Logger LOG = LoggerFactory.getLogger(JavaxWebsocketTransport.class);

    public JavaxWebsocketTransport(URI endpointURI, ReplicaTransport httpTransport) {
        super(endpointURI, httpTransport);
    }

    @OnOpen
    public void onOpen(Session userSession) {
        LOG.debug("opening websocket");
        this.userSession = userSession;
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        LOG.debug("closing websocket");
        this.userSession = null;
    }

    @OnMessage
    public void onMessage(String message) {
        if (this.messageHandler != null && message != null) {
            try {
                this.messageHandler.handleMessage(message.getBytes());
            }
            catch (WebsocketError e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                try {
                    this.userSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, e.getLocalizedMessage()));
                }
                catch (IOException e1) {
                    LOG.error(message, (Throwable)e1);
                }
            }
        }
    }

    @OnMessage
    public void onMessage(ByteBuffer bytes) {
        if (this.messageHandler != null) {
            try {
                this.messageHandler.handleMessage(bytes.array());
            }
            catch (WebsocketError e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                try {
                    this.userSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getLocalizedMessage()));
                }
                catch (IOException e1) {
                    LOG.error(e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        }
    }

    @Override
    public void addMessageHandler(WebsocketTransport.MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    @Override
    void send(ByteBuffer message) {
        this.userSession.getAsyncRemote().sendBinary(message);
    }

    @Override
    public void open() {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.setDefaultMaxSessionIdleTimeout(0L);
            container.connectToServer((Object)this, this.endpointURI);
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new WebsocketError(e);
        }
    }

    @Override
    public void setMaxIdleTimeout(int timeout) {
        if (this.userSession != null) {
            this.userSession.setMaxIdleTimeout((long)timeout);
        }
    }

    public void close() {
        if (this.userSession != null) {
            try {
                this.userSession.close();
            }
            catch (IOException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void close(int code, String reason) {
        if (this.userSession != null) {
            try {
                CloseReason.CloseCode closeCode = CloseReason.CloseCodes.getCloseCode((int)code);
                CloseReason closeReason = new CloseReason(closeCode, reason);
                this.userSession.close(closeReason);
            }
            catch (IOException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

