/*
 * Decompiled with CFR 0.152.
 */
package org.ic4j.websocket;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;
import org.ic4j.agent.ReplicaResponse;
import org.ic4j.agent.ReplicaTransport;
import org.ic4j.agent.replicaapi.Envelope;
import org.ic4j.agent.requestid.RequestId;
import org.ic4j.types.Principal;
import org.ic4j.websocket.WebsocketError;
import org.ic4j.websocket.WsAgentRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebsocketTransport
implements ReplicaTransport {
    static Logger LOG = LoggerFactory.getLogger(WebsocketTransport.class);
    ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new CBORFactory()).registerModule((Module)new Jdk8Module());
    protected MessageHandler messageHandler;
    protected URI endpointURI;
    ReplicaTransport httpTransport;

    public WebsocketTransport(URI endpointURI, ReplicaTransport httpTransport) {
        this.endpointURI = endpointURI;
        this.httpTransport = httpTransport;
    }

    public abstract void open();

    public abstract void addMessageHandler(MessageHandler var1);

    public abstract void close(int var1, String var2);

    public abstract void setMaxIdleTimeout(int var1);

    abstract void send(ByteBuffer var1);

    protected void send(byte[] payload) {
        WsAgentRequestMessage message = new WsAgentRequestMessage();
        try {
            Envelope envelope;
            message.envelope = envelope = (Envelope)this.objectMapper.readValue(payload, Envelope.class);
            this.sendMessage(message);
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new WebsocketError(e);
        }
    }

    public void sendMessage(Object message) {
        ObjectWriter objectWriter = this.objectMapper.writerFor(message.getClass());
        try {
            byte[] buf = objectWriter.writeValueAsBytes(message);
            ByteBuffer bytes = ByteBuffer.wrap(buf);
            this.send(bytes);
        }
        catch (JsonProcessingException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<ReplicaResponse> status() {
        return this.httpTransport.status();
    }

    public CompletableFuture<ReplicaResponse> query(Principal canisterId, byte[] envelope, Map<String, String> headers) {
        return this.httpTransport.query(canisterId, envelope, headers);
    }

    public CompletableFuture<ReplicaResponse> call(Principal canisterId, byte[] payload, RequestId requestId, Map<String, String> headers) {
        CompletableFuture<ReplicaResponse> response = new CompletableFuture<ReplicaResponse>();
        try {
            this.send(payload);
            ReplicaResponse replicaResponse = new ReplicaResponse();
            replicaResponse.payload = ArrayUtils.EMPTY_BYTE_ARRAY;
            response.complete(replicaResponse);
        }
        catch (Exception e) {
            response.completeExceptionally(e);
        }
        return response;
    }

    public CompletableFuture<ReplicaResponse> readState(Principal canisterId, byte[] envelope, Map<String, String> headers) {
        return null;
    }

    public static interface MessageHandler {
        public void handleMessage(byte[] var1) throws WebsocketError;
    }
}

