/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector;

import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.filter.ComponentFilter;
import net.fortuna.ical4j.filter.FilterExpression;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.MediaType;
import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.ObjectNotFoundException;
import org.ical4j.connector.ObjectStoreException;

public interface CalendarCollection
extends ObjectCollection<Calendar> {
    public Calendar getTimeZone();

    public String[] getSupportedComponentTypes();

    public MediaType[] getSupportedMediaTypes();

    public long getMaxResourceSize();

    public Instant getMinDateTime();

    public Instant getMaxDateTime();

    public Integer getMaxInstances();

    public Integer getMaxAttendeesPerInstance();

    default public Calendar getFreeBusy(Temporal start, Temporal end) {
        return Calendars.wrap((CalendarComponent[])new CalendarComponent[]{new VFreeBusy()});
    }

    @Deprecated
    default public Uid addCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        return new Uid(this.add(calendar));
    }

    @Deprecated
    default public Calendar getCalendar(String uid) throws ObjectNotFoundException {
        return this.get(uid).orElse(null);
    }

    @Deprecated
    default public List<Calendar> getCalendars(String ... uids) {
        return this.getAll(uids);
    }

    @Deprecated
    default public Calendar removeCalendar(String uid) throws FailedOperationException {
        return (Calendar)this.removeAll(uid).get(0);
    }

    public Uid[] merge(Calendar var1) throws FailedOperationException, ObjectStoreException;

    @Override
    default public List<Calendar> query(FilterExpression filterExpression) {
        Predicate filter = new ComponentFilter().predicate(filterExpression);
        return this.getAll(new String[0]).stream().filter(c -> c.getComponents().stream().anyMatch(filter)).collect(Collectors.toList());
    }

    public Calendar export();
}

