/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.filter.FilterExpression;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardList;
import net.fortuna.ical4j.vcard.filter.VCardFilter;
import net.fortuna.ical4j.vcard.property.Uid;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.ObjectNotFoundException;
import org.ical4j.connector.ObjectStoreException;
import org.slf4j.LoggerFactory;

public interface CardCollection
extends ObjectCollection<VCard> {
    @Deprecated
    default public Uid addCard(VCard card) throws ObjectStoreException, ConstraintViolationException {
        return new Uid(this.add(card));
    }

    public Uid[] merge(VCard var1) throws ObjectStoreException, ConstraintViolationException;

    @Deprecated
    default public VCard removeCard(String uid) throws ObjectNotFoundException, FailedOperationException {
        List result = this.removeAll(uid);
        return (VCard)result.get(0);
    }

    @Deprecated
    default public VCard getCard(String uid) throws ObjectNotFoundException, FailedOperationException {
        Optional<Object> card = this.get(uid);
        return card.orElse(null);
    }

    @Deprecated
    default public VCardList getCards(String ... uids) throws FailedOperationException {
        ArrayList<VCard> cards = new ArrayList<VCard>();
        for (String uid : uids) {
            try {
                cards.add(this.getCard(uid));
            }
            catch (ObjectNotFoundException e) {
                LoggerFactory.getLogger(CardCollection.class).warn("Calendar not found: " + uid);
            }
        }
        return new VCardList(cards);
    }

    @Override
    default public List<VCard> query(FilterExpression filterExpression) {
        Predicate filter = new VCardFilter().predicate(filterExpression);
        return this.getAll(new String[0]).stream().filter(filter).collect(Collectors.toList());
    }

    public VCard[] export();
}

