/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fortuna.ical4j.filter.FilterExpression;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.ObjectCollectionListenerSupport;
import org.ical4j.connector.ObjectStoreException;

public interface ObjectCollection<T>
extends ObjectCollectionListenerSupport<T> {
    public static final String DEFAULT_COLLECTION = "default";

    public String getDisplayName();

    public String getDescription();

    public List<String> listObjectUIDs();

    default public List<T> getAll(String ... uid) {
        ArrayList result = new ArrayList();
        if (uid.length > 0) {
            for (String u : uid) {
                Optional<Object> cal = this.get(u);
                cal.ifPresent(result::add);
            }
        } else {
            for (String u : this.listObjectUIDs()) {
                Optional<Object> cal = this.get(u);
                cal.ifPresent(result::add);
            }
        }
        return result;
    }

    public Optional<T> get(String var1);

    public String add(T var1) throws ObjectStoreException;

    public List<T> removeAll(String ... var1) throws FailedOperationException;

    default public List<T> query(FilterExpression filterExpression) {
        throw new UnsupportedOperationException("Collection filtering not yet supported");
    }

    public void delete() throws ObjectStoreException;
}

