/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector;

import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.event.ListenerList;
import org.ical4j.connector.event.ObjectCollectionEvent;
import org.ical4j.connector.event.ObjectCollectionListener;

public interface ObjectCollectionListenerSupport<T> {
    public ListenerList<ObjectCollectionListener<T>> getObjectCollectionListeners();

    default public void addObjectCollectionListener(ObjectCollectionListener<T> listener) {
        this.getObjectCollectionListeners().add(listener);
    }

    default public void removeObjectCollectionListener(ObjectCollectionListener<T> listener) {
        this.getObjectCollectionListeners().remove(listener);
    }

    default public void fireOnAddEvent(ObjectCollection<T> source, T object) {
        this.getObjectCollectionListeners().getAll().forEach(listener -> listener.onAdd(new ObjectCollectionEvent<Object>(source, object)));
    }

    default public void fireOnRemoveEvent(ObjectCollection<T> source, T object) {
        this.getObjectCollectionListeners().getAll().forEach(listener -> listener.onRemove(new ObjectCollectionEvent<Object>(source, object)));
    }

    default public void fireOnMergeEvent(ObjectCollection<T> source, T object) {
        this.getObjectCollectionListeners().getAll().forEach(listener -> listener.onMerge(new ObjectCollectionEvent<Object>(source, object)));
    }

    default public void fireOnReplaceEvent(ObjectCollection<T> source, T object) {
        this.getObjectCollectionListeners().getAll().forEach(listener -> listener.onReplace(new ObjectCollectionEvent<Object>(source, object)));
    }
}

