/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector;

import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.ObjectStore;
import org.ical4j.connector.event.ListenerList;
import org.ical4j.connector.event.ObjectStoreEvent;
import org.ical4j.connector.event.ObjectStoreListener;

public interface ObjectStoreListenerSupport<T> {
    public ListenerList<ObjectStoreListener<T>> getObjectStoreListeners();

    default public void addObjectStoreListener(ObjectStoreListener<T> listener) {
        this.getObjectStoreListeners().add(listener);
    }

    default public void removeObjectStoreListener(ObjectStoreListener<T> listener) {
        this.getObjectStoreListeners().remove(listener);
    }

    default public void fireOnAddEvent(ObjectStore<T, ? extends ObjectCollection<T>> source, ObjectCollection<T> object) {
        this.getObjectStoreListeners().getAll().forEach(listener -> listener.collectionAdded(new ObjectStoreEvent(source, object)));
    }

    default public void fireOnRemoveEvent(ObjectStore<T, ? extends ObjectCollection<T>> source, ObjectCollection<T> object) {
        this.getObjectStoreListeners().getAll().forEach(listener -> listener.collectionRemoved(new ObjectStoreEvent(source, object)));
    }
}

