/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Calendar;
import org.ical4j.connector.AbstractObjectStore;
import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.ObjectNotFoundException;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.AbstractLocalObjectCollection;

public abstract class AbstractLocalObjectStore<T, C extends AbstractLocalObjectCollection<T>>
extends AbstractObjectStore<T, C> {
    private final File root;

    AbstractLocalObjectStore(File root) {
        this.root = Objects.requireNonNull(root);
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException("Root must be a directory");
        }
        if (!root.exists() && !root.mkdirs()) {
            throw new IllegalArgumentException("Unable to initialise root directory");
        }
    }

    protected File getRoot() {
        return this.root;
    }

    @Override
    public boolean connect() throws ObjectStoreException {
        return false;
    }

    @Override
    public boolean connect(String username, char[] password) throws ObjectStoreException {
        return false;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public C addCollection(String id) throws ObjectStoreException {
        return (C)this.addCollection(id, "default");
    }

    @Override
    public C addCollection(String id, String workspace) throws ObjectStoreException {
        File collectionDir = new File(this.getWorkspaceDir(workspace), id);
        if (collectionDir.exists() && !collectionDir.isDirectory() || !collectionDir.exists() && !collectionDir.mkdirs()) {
            throw new ObjectStoreException("Unable to initialise collection");
        }
        ObjectCollection<Object> collection = null;
        try {
            collection = this.getCollection(id);
        }
        catch (ObjectNotFoundException e) {
            try {
                collection = this.newCollection(id, workspace);
            }
            catch (IOException ex) {
                throw new ObjectStoreException(ex);
            }
        }
        this.fireOnAddEvent(this, collection);
        return (C)collection;
    }

    protected abstract C newCollection(String var1, String var2) throws IOException;

    @Override
    public C addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        return (C)this.addCollection(id, displayName, description, supportedComponents, timezone, "default");
    }

    @Override
    public C addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone, String workspace) throws ObjectStoreException {
        ObjectCollection collection = this.addCollection(id, workspace);
        try {
            ((AbstractLocalObjectCollection)collection).setDisplayName(displayName);
            ((AbstractLocalObjectCollection)collection).setDescription(description);
            ((AbstractLocalObjectCollection)collection).setSupportedComponents(supportedComponents);
            ((AbstractLocalObjectCollection)collection).setTimeZone(timezone);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        this.fireOnAddEvent(this, collection);
        return (C)collection;
    }

    @Override
    public C removeCollection(String id) throws ObjectNotFoundException, ObjectStoreException {
        ObjectCollection collection = this.getCollection(id);
        ((AbstractLocalObjectCollection)collection).delete();
        this.fireOnRemoveEvent(this, collection);
        return (C)collection;
    }

    @Override
    public C getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        return (C)this.getCollection(id, "default");
    }

    @Override
    public C getCollection(String id, String workspace) throws ObjectStoreException, ObjectNotFoundException {
        File collectionDir = new File(this.getWorkspaceDir(workspace), id);
        if (!collectionDir.exists() || !collectionDir.isDirectory()) {
            throw new ObjectNotFoundException("Unable to retrieve collection");
        }
        try {
            return this.newCollection(id, workspace);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public List<C> getCollections() {
        return this.getCollections("default");
    }

    @Override
    public List<C> getCollections(String workspace) {
        return Arrays.stream(Objects.requireNonNull(this.getWorkspaceDir(workspace).list())).map(name -> {
            try {
                return this.newCollection((String)name, workspace);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    protected File getWorkspaceDir(String workspace) {
        File workspaceDir = new File(this.root, workspace);
        if (!workspaceDir.exists() && !workspaceDir.mkdir()) {
            throw new IllegalArgumentException("Invalid workspace");
        }
        return workspaceDir;
    }

    @Override
    public List<String> listWorkspaces() {
        return Arrays.asList(Objects.requireNonNull(this.root.list()));
    }
}

