/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.ical4j.connector.CalendarCollection;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.MediaType;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.AbstractLocalObjectCollection;

public class LocalCalendarCollection
extends AbstractLocalObjectCollection<Calendar>
implements CalendarCollection {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[1];

    public LocalCalendarCollection(File root) throws IOException {
        super(root);
    }

    @Override
    public MediaType[] getSupportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    public long getMaxResourceSize() {
        return 0L;
    }

    @Override
    public Instant getMinDateTime() {
        return null;
    }

    @Override
    public Instant getMaxDateTime() {
        return null;
    }

    @Override
    public Integer getMaxInstances() {
        return null;
    }

    @Override
    public Integer getMaxAttendeesPerInstance() {
        return null;
    }

    @Override
    public List<String> listObjectUIDs() {
        return Arrays.stream(this.getObjectFiles()).map(file -> file.getName().split(".ics")[0]).collect(Collectors.toList());
    }

    @Override
    public String add(Calendar object) throws ObjectStoreException {
        Uid uid = object.getUid();
        Optional<Calendar> existing = this.get(uid.getValue());
        if (existing.isPresent()) {
            throw new ObjectStoreException("Calendar already exists");
        }
        try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".ics"));){
            new CalendarOutputter(false).output(object, (Writer)writer);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Error writing calendar file", e);
        }
        this.fireOnAddEvent(this, object);
        return uid.getValue();
    }

    @Override
    public Optional<Calendar> get(String uid) {
        File calendarFile = new File(this.getRoot(), uid + ".ics");
        if (!calendarFile.exists()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Calendars.load((String)calendarFile.getAbsolutePath()));
        }
        catch (IOException | ParserException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Calendar> removeAll(String ... uid) throws FailedOperationException {
        ArrayList<Calendar> removed = new ArrayList<Calendar>();
        for (String u : uid) {
            Optional<Calendar> cal;
            File calendarFile = new File(this.getRoot(), u + ".ics");
            if (!calendarFile.exists() || !(cal = this.get(u)).isPresent()) continue;
            if (!calendarFile.delete()) {
                throw new FailedOperationException("Unable to delete calendar: " + u);
            }
            removed.add(cal.get());
            this.fireOnRemoveEvent(this, cal.get());
        }
        return removed;
    }

    @Override
    public Uid[] merge(Calendar calendar) throws ObjectStoreException {
        Calendar[] uidCalendars;
        for (Calendar c : uidCalendars = calendar.split()) {
            Uid uid = c.getUid();
            Optional<Calendar> existing = this.get(uid.getValue());
            if (existing.isPresent()) {
                throw new ObjectStoreException("Calendar already exists");
            }
            try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".ics"));){
                new CalendarOutputter(false).output(c, (Writer)writer);
            }
            catch (IOException e) {
                throw new ObjectStoreException("Error writing calendar file", e);
            }
        }
        this.fireOnMergeEvent(this, calendar);
        return (Uid[])Arrays.stream(uidCalendars).map(Calendar::getUid).toArray(Uid[]::new);
    }

    @Override
    public Calendar export() {
        Calendar export = new Calendar();
        for (File object : this.getObjectFiles()) {
            try {
                export = export.merge(Calendars.load((String)object.getAbsolutePath()));
            }
            catch (IOException | ParserException e) {
                throw new RuntimeException(e);
            }
        }
        return export;
    }

    private File[] getObjectFiles() {
        return this.getRoot().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".ics"));
    }

    static {
        LocalCalendarCollection.SUPPORTED_MEDIA_TYPES[0] = MediaType.ICALENDAR_2_0;
    }
}

