/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.VCardOutputter;
import net.fortuna.ical4j.vcard.property.Uid;
import org.ical4j.connector.CardCollection;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.MediaType;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.AbstractLocalObjectCollection;

public class LocalCardCollection
extends AbstractLocalObjectCollection<VCard>
implements CardCollection {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[1];

    public LocalCardCollection(File root) throws IOException {
        super(root);
    }

    @Override
    public List<String> listObjectUIDs() {
        return Arrays.stream(this.getObjectFiles()).map(file -> file.getName().split(".vcf")[0]).collect(Collectors.toList());
    }

    @Override
    public String add(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getRequiredProperty((Enum)PropertyName.UID);
        Optional<VCard> existing = this.get(uid.getValue());
        if (existing.isPresent()) {
            throw new ObjectStoreException("Card already exists");
        }
        try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".vcf"));){
            new VCardOutputter(false).output(card, (Writer)writer);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Error writing card file", e);
        }
        this.fireOnAddEvent(this, card);
        return uid.getValue();
    }

    @Override
    public Uid[] merge(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getRequiredProperty(PropertyName.UID.toString());
        Optional<VCard> existing = this.get(uid.getValue());
        existing.ifPresent(vCard -> vCard.addAll((Collection)card.getProperties(new String[0])));
        this.save(card);
        this.fireOnMergeEvent(this, card);
        return Collections.singletonList(uid).toArray(new Uid[0]);
    }

    private void save(VCard card) throws ObjectStoreException {
        Uid uid = (Uid)card.getRequiredProperty(PropertyName.UID.toString());
        try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".vcf"));){
            new VCardOutputter(false).output(card, (Writer)writer);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Error writing card file", e);
        }
    }

    @Override
    public Optional<VCard> get(String uid) {
        File cardFile = new File(this.getRoot(), uid + ".vcf");
        if (!cardFile.exists()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new VCardBuilder(Files.newInputStream(cardFile.toPath(), new OpenOption[0])).build());
        }
        catch (IOException | ParserException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<VCard> removeAll(String ... uid) throws FailedOperationException {
        ArrayList<VCard> removed = new ArrayList<VCard>();
        for (String u : uid) {
            Optional<VCard> card;
            File cardFile = new File(this.getRoot(), u + ".vcf");
            if (!cardFile.exists() || !(card = this.get(u)).isPresent()) continue;
            if (!cardFile.delete()) {
                throw new FailedOperationException("Unable to delete card: " + u);
            }
            removed.add(card.get());
            this.fireOnRemoveEvent(this, card.get());
        }
        return removed;
    }

    @Override
    public VCard[] export() {
        ArrayList<VCard> export = new ArrayList<VCard>(this.getAll(new String[0]));
        return export.toArray(new VCard[0]);
    }

    private File[] getObjectFiles() {
        return this.getRoot().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".vcf"));
    }

    static {
        LocalCardCollection.SUPPORTED_MEDIA_TYPES[0] = MediaType.VCARD_4_0;
    }
}

