/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.codec.DecoderException;
import org.mnode.ical4j.serializer.JsonMapper;

public class JCardMapper
extends StdDeserializer<VCard>
implements JsonMapper {
    private final ParameterFactoryRegistry parameterFactoryRegistry = new ParameterFactoryRegistry();
    private final PropertyFactoryRegistry propertyFactoryRegistry = new PropertyFactoryRegistry();

    public JCardMapper(Class<?> vc) {
        super(vc);
    }

    public VCard deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        VCard card = new VCard();
        this.assertTextValue(p, "vcard");
        this.assertNextToken(p, JsonToken.START_ARRAY);
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            try {
                card.add(this.parseProperty(p));
            }
            catch (URISyntaxException | ParseException | DecoderException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return card;
    }

    private Property parseProperty(JsonParser p) throws IOException, URISyntaxException, ParseException, DecoderException {
        String propertyType;
        this.assertCurrentToken(p, JsonToken.START_ARRAY);
        String propName = p.nextTextValue();
        this.assertNextToken(p, JsonToken.START_OBJECT);
        ArrayList<Object> params = new ArrayList<Object>();
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            Parameter parameter = ((ParameterFactory)this.parameterFactoryRegistry.getFactory(p.currentName())).createParameter(p.getText());
            params.add(parameter);
        }
        switch (propertyType = p.nextTextValue()) {
            case "binary": {
                params.add(Value.BINARY);
            }
            case "duration": {
                params.add(Value.DURATION);
            }
            case "date": {
                params.add(Value.DATE);
            }
            case "date-time": {
                params.add(Value.DATE_TIME);
            }
            case "uri": {
                params.add(Value.URI);
            }
        }
        String value = p.nextTextValue();
        this.assertNextToken(p, JsonToken.END_ARRAY);
        return ((PropertyFactory)this.propertyFactoryRegistry.getFactory(propName)).createProperty(new ParameterList(params), value);
    }
}

