/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jot;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.data.DefaultParameterFactorySupplier;
import net.fortuna.ical4j.data.DefaultPropertyFactorySupplier;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterBuilder;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import org.mnode.ical4j.serializer.JCalDecoder;
import org.mnode.ical4j.serializer.JsonMapper;

public abstract class AbstractJotCalMapper<T>
extends StdDeserializer<T>
implements JsonMapper {
    private final List<ParameterFactory<?>> parameterFactories = new DefaultParameterFactorySupplier().get();
    private final List<PropertyFactory<?>> propertyFactories = new DefaultPropertyFactorySupplier().get();

    public AbstractJotCalMapper(Class<?> vc) {
        super(vc);
    }

    protected List<Property> parsePropertyList(String propertyName, JsonParser p) throws IOException, URISyntaxException, ParseException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            properties.add(this.parseProperty(propertyName, p));
        }
        return properties;
    }

    protected Property parseProperty(String propertyName, JsonParser p) throws IOException, URISyntaxException, ParseException {
        PropertyBuilder propertyBuilder = new PropertyBuilder(this.propertyFactories);
        propertyBuilder.name(propertyName);
        if (JsonToken.START_ARRAY.equals((Object)p.currentToken())) {
            StringBuilder b = new StringBuilder();
            while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                this.assertCurrentToken(p, JsonToken.VALUE_STRING);
                b.append(p.getText());
                b.append(',');
            }
            propertyBuilder.value(b.toString());
        } else if (JsonToken.START_OBJECT.equals((Object)p.currentToken())) {
            while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                this.assertCurrentToken(p, JsonToken.FIELD_NAME);
                if (this.isParameter(p.currentName())) {
                    propertyBuilder.parameter(this.parseParameter(p));
                    continue;
                }
                this.assertNextScalarValue(p);
                propertyBuilder.value(this.decodeValue(propertyName, p.getText()));
            }
        } else {
            this.assertCurrentScalarValue(p);
            propertyBuilder.value(this.decodeValue(propertyName, p.getText()));
        }
        return propertyBuilder.build();
    }

    protected Parameter parseParameter(JsonParser p) throws IOException, URISyntaxException {
        this.assertNextScalarValue(p);
        return new ParameterBuilder(this.parameterFactories).name(p.currentName()).value(p.getText()).build();
    }

    private boolean isParameter(String fieldName) {
        return Arrays.asList("ABBREV", "CN", "ALTREP", "CUTYPE", "DIR", "DELEGATED-FROM", "DELEGATED-TO", "DISPLAY", "EMAIL", "ENCODING", "FBTYPE", "FEATURE", "FMTTYPE", "LABEL", "LANGUAGE", "MEMBER", "PARTSTAT", "RANGE", "RELATED", "RELTYPE", "ROLE", "RSVP", "SCHEDULE-AGENT", "SCHEDULE-STATUS", "SENT-BY", "TYPE", "TZID", "VALUE", "VVENUE").contains(fieldName.toUpperCase());
    }

    private String decodeValue(String propertyName, String value) {
        switch (propertyName) {
            case "trigger": 
            case "created": 
            case "last-modified": 
            case "recurrence-id": 
            case "dtstamp": {
                return JCalDecoder.INSTANT.decode(value);
            }
            case "dtstart": 
            case "dtend": 
            case "rdate": 
            case "exdate": 
            case "due": {
                return JCalDecoder.DATE_TIME.decode(value);
            }
        }
        return value;
    }
}

