/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyContainer;
import org.mnode.ical4j.serializer.JsonBuilder;

public class JsonObjectBuilder
implements JsonBuilder {
    private final PropertyContainer propertyContainer;
    private final List<String> propertyNames;

    public JsonObjectBuilder(PropertyContainer propertyContainer, List<String> propertyNames) {
        this.propertyContainer = propertyContainer;
        this.propertyNames = propertyNames;
    }

    public JsonNode build() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        Map<String, List<Property>> propertyMap = this.propertyContainer.getProperties(new String[0]).stream().filter(p -> this.propertyNames.contains(p.getName())).collect(Collectors.groupingBy(Property::getName));
        for (String propName : propertyMap.keySet()) {
            List<Property> props = propertyMap.get(propName);
            if (props.size() == 1) {
                this.putProperty(node, props.get(0));
                continue;
            }
            ArrayNode arrayNode = node.putArray(propName.toLowerCase());
            props.forEach(p -> this.putProperty(arrayNode, (Property)p));
        }
        return node;
    }

    private ObjectNode putProperty(ObjectNode node, Property prop) {
        if (prop.getParameters(new String[0]).isEmpty()) {
            node.put(prop.getName().toLowerCase(), prop.getValue());
        } else {
            ObjectNode pobj = node.putObject(prop.getName().toLowerCase());
            prop.getParameters(new String[0]).forEach(p -> pobj.put(p.getName().toLowerCase(), p.getValue()));
            pobj.put(this.valueFieldName(prop), this.encodeValue(prop));
        }
        return node;
    }

    private ArrayNode putProperty(ArrayNode node, Property prop) {
        if (prop.getParameters(new String[0]).isEmpty()) {
            node.add(prop.getValue());
        } else {
            ObjectNode pobj = node.addObject();
            pobj.put(this.valueFieldName(prop), this.encodeValue(prop));
        }
        return node;
    }

    private String valueFieldName(Property prop) {
        switch (prop.getName()) {
            case "ORGANIZER": {
                return "cal-address";
            }
        }
        Optional value = prop.getParameter("VALUE");
        return value.map(value1 -> value1.getValue().toLowerCase()).orElse("value");
    }
}

