/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.VCard;
import org.mnode.ical4j.serializer.jsonld.AbstractJsonLdSerializer;
import org.mnode.ical4j.serializer.jsonld.AbstractNodeBuilder;

public class OrganizationJsonLdSerializer
extends AbstractJsonLdSerializer<VCard> {
    public OrganizationJsonLdSerializer(Class<VCard> t) {
        super(t);
    }

    @Override
    protected JsonNode buildSchema(VCard card) {
        AbstractNodeBuilder<VCard> builder = new OrganizationNodeBuilder().component(card);
        return builder.build();
    }

    public static class OrganizationNodeBuilder
    extends AbstractNodeBuilder<VCard> {
        public OrganizationNodeBuilder() {
            super("Organization");
        }

        @Override
        public JsonNode build() {
            ObjectNode node = this.createObjectNode();
            this.putIfNotAbsent("@id", node, (Enum<?>)PropertyName.UID);
            this.putIfNotAbsent("name", node, (Enum<?>)PropertyName.FN);
            this.putIfNotAbsent("email", node, (Enum<?>)PropertyName.EMAIL);
            this.putIfNotAbsent("image", node, (Enum<?>)PropertyName.PHOTO);
            this.putIfNotAbsent("logo", node, (Enum<?>)PropertyName.LOGO);
            this.putIfNotAbsent("telephone", node, (Enum<?>)PropertyName.TEL);
            this.putIfNotAbsent("url", node, (Enum<?>)PropertyName.URL);
            this.setObject("address", node, (Enum<?>)PropertyName.ADR);
            this.setObject("member", node, (Enum<?>)PropertyName.MEMBER);
            return node;
        }
    }
}

