/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import org.apache.commons.codec.DecoderException;
import org.mnode.ical4j.serializer.JsonMapper;

public abstract class AbstractVCardMapper<T>
extends StdDeserializer<T>
implements JsonMapper {
    private final PropertyFactoryRegistry propertyFactoryRegistry = new PropertyFactoryRegistry();
    private final ParameterFactoryRegistry parameterFactoryRegistry = new ParameterFactoryRegistry();

    public AbstractVCardMapper(Class<?> vc) {
        super(vc);
    }

    protected List<Property> parsePropertyList(String propertyName, JsonParser p) throws IOException, URISyntaxException, ParseException, DecoderException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            properties.add(this.parseProperty(propertyName, p));
        }
        return properties;
    }

    protected Property parseProperty(String propertyName, JsonParser p) throws IOException, URISyntaxException, ParseException, DecoderException {
        String value = null;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (JsonToken.START_ARRAY.equals((Object)p.currentToken())) {
            StringBuilder b = new StringBuilder();
            while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                this.assertCurrentToken(p, JsonToken.VALUE_STRING);
                b.append(p.getText());
                b.append(',');
            }
            value = b.toString();
        } else if (JsonToken.START_OBJECT.equals((Object)p.currentToken())) {
            while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                this.assertCurrentToken(p, JsonToken.FIELD_NAME);
                if (this.isParameter(p.currentName())) {
                    parameters.add(this.parseParameter(p));
                    continue;
                }
                this.assertNextScalarValue(p);
                value = p.getText();
            }
        } else {
            this.assertCurrentScalarValue(p);
            value = p.getText();
        }
        return ((PropertyFactory)this.propertyFactoryRegistry.getFactory(propertyName)).createProperty(new ParameterList(parameters), value);
    }

    protected Parameter parseParameter(JsonParser p) throws IOException {
        this.assertNextScalarValue(p);
        return ((ParameterFactory)this.parameterFactoryRegistry.getFactory(p.currentName())).createParameter(p.getText());
    }

    private boolean isParameter(String fieldName) {
        return Arrays.asList(ParameterName.PREF).contains(ParameterName.valueOf((String)fieldName));
    }
}

