/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.VCard;
import org.mnode.ical4j.serializer.jsonld.AbstractJsonLdSerializer;
import org.mnode.ical4j.serializer.jsonld.AbstractNodeBuilder;

public class PlaceJsonLdSerializer
extends AbstractJsonLdSerializer<VCard> {
    public PlaceJsonLdSerializer(Class<VCard> t) {
        super(t);
    }

    @Override
    protected JsonNode buildSchema(VCard card) {
        AbstractNodeBuilder<VCard> builder = new PlaceNodeBuilder().component(card);
        return builder.build();
    }

    public static class PlaceNodeBuilder
    extends AbstractNodeBuilder<VCard> {
        public PlaceNodeBuilder() {
            super("Place");
        }

        @Override
        public JsonNode build() {
            ObjectNode node = this.createObjectNode();
            this.putIfNotAbsent("@id", node, (Enum<?>)PropertyName.UID);
            this.putIfNotAbsent("name", node, (Enum<?>)PropertyName.FN);
            this.putIfNotAbsent("image", node, (Enum<?>)PropertyName.PHOTO);
            this.putIfNotAbsent("url", node, (Enum<?>)PropertyName.URL);
            this.setObject("address", node, (Enum<?>)PropertyName.ADR);
            return node;
        }
    }
}

