/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fortuna.ical4j.data.DefaultParameterFactorySupplier;
import net.fortuna.ical4j.data.DefaultPropertyFactorySupplier;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.PropertyFactory;
import org.mnode.ical4j.serializer.JsonMapper;
import org.mnode.ical4j.serializer.ParameterMapper;
import org.mnode.ical4j.serializer.ParameterMapperImpl;
import org.mnode.ical4j.serializer.PropertyMapper;

public class ContentMapper<T extends PropertyContainer>
extends JsonDeserializer<T>
implements JsonMapper {
    private final Supplier<T> supplier;
    private final PropertyMapper propertyMapper;
    private final ParameterMapper parameterMapper;

    public ContentMapper(Supplier<T> supplier) {
        this.supplier = supplier;
        this.propertyMapper = new PropertyMapperImpl(new DefaultPropertyFactorySupplier().get());
        this.parameterMapper = new ParameterMapperImpl(new DefaultParameterFactorySupplier().get());
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        this.assertCurrentToken(p, JsonToken.START_OBJECT);
        PropertyContainer container = (PropertyContainer)this.supplier.get();
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            this.assertCurrentToken(p, JsonToken.FIELD_NAME);
            String propertyName = p.currentName();
            try {
                if (JsonToken.START_ARRAY.equals((Object)p.nextToken())) {
                    container.addAll(this.parsePropertyList(p, propertyName));
                    continue;
                }
                container.add(this.propertyMapper.map(p));
            }
            catch (URISyntaxException | ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return (T)container;
    }

    private List<Property> parsePropertyList(JsonParser p, String propertyName) throws IOException, URISyntaxException, ParseException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            properties.add(new PropertyMapperImpl(new DefaultPropertyFactorySupplier().get(), propertyName).map(p));
        }
        return properties;
    }

    class PropertyMapperImpl
    implements PropertyMapper {
        private final List<PropertyFactory<? extends Property>> propertyFactories;
        private final String propertyName;

        public PropertyMapperImpl(List<PropertyFactory<? extends Property>> propertyFactories) {
            this(propertyFactories, null);
        }

        public PropertyMapperImpl(List<PropertyFactory<? extends Property>> propertyFactories, String propertyName) {
            this.propertyFactories = propertyFactories;
            this.propertyName = propertyName;
        }

        @Override
        public Property map(JsonParser p) throws IOException {
            PropertyBuilder propertyBuilder = new PropertyBuilder(this.propertyFactories);
            propertyBuilder.name(this.propertyName != null ? this.propertyName.toUpperCase() : p.currentName().toUpperCase());
            if (JsonToken.START_ARRAY.equals((Object)p.currentToken())) {
                StringBuilder b = new StringBuilder();
                while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                    ContentMapper.this.assertCurrentToken(p, JsonToken.VALUE_STRING);
                    b.append(p.getText());
                    b.append(',');
                }
                propertyBuilder.value(b.toString());
            } else if (JsonToken.START_OBJECT.equals((Object)p.currentToken())) {
                while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                    ContentMapper.this.assertCurrentToken(p, JsonToken.FIELD_NAME);
                    if (this.isParameter(p.currentName())) {
                        propertyBuilder.parameter(ContentMapper.this.parameterMapper.map(p));
                        continue;
                    }
                    ContentMapper.this.assertNextScalarValue(p);
                    propertyBuilder.value(ContentMapper.this.decodeValue(this.propertyName != null ? this.propertyName : p.currentName(), p.getText()));
                }
            } else {
                ContentMapper.this.assertCurrentScalarValue(p);
                propertyBuilder.value(ContentMapper.this.decodeValue(this.propertyName != null ? this.propertyName : p.currentName(), p.getText()));
            }
            return propertyBuilder.build();
        }

        private boolean isParameter(String fieldName) {
            return Arrays.asList("ABBREV", "CN", "ALTREP", "CUTYPE", "DIR", "DELEGATED-FROM", "DELEGATED-TO", "DISPLAY", "EMAIL", "ENCODING", "FBTYPE", "FEATURE", "FMTTYPE", "LABEL", "LANGUAGE", "MEMBER", "PARTSTAT", "RANGE", "RELATED", "RELTYPE", "ROLE", "RSVP", "SCHEDULE-AGENT", "SCHEDULE-STATUS", "SENT-BY", "TYPE", "TZID", "VALUE", "VVENUE").contains(fieldName.toUpperCase()) || fieldName.toUpperCase().startsWith("X-");
        }
    }
}

