/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.function.UnaryOperator;
import net.fortuna.ical4j.model.ZoneOffsetAdapter;
import org.apache.commons.codec.StringDecoder;

public class JCalDecoder
implements StringDecoder {
    public static final JCalDecoder DATE = new JCalDecoder(s -> DateTimeFormatter.BASIC_ISO_DATE.format(DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)s)));
    public static final JCalDecoder DATE_TIME = new JCalDecoder(s -> DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssX").withZone(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy'-'MM'-'dd'T'HH':'mm[':'ss[X]]").parseBest((CharSequence)s, new InstantTemporalQuery(), new LocalDateTimeTemporalQuery())));
    public static final JCalDecoder INSTANT = new JCalDecoder(s -> DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s)));
    public static final JCalDecoder TIME = new JCalDecoder(s -> DateTimeFormatter.ofPattern("HHmmss").format(DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)s)));
    public static final JCalDecoder UTCOFFSET = new JCalDecoder(s -> new ZoneOffsetAdapter(ZoneOffset.of(s)).toString());
    private final UnaryOperator<String> function;

    public JCalDecoder(UnaryOperator<String> function) {
        this.function = function;
    }

    public String decode(String source) {
        return (String)this.function.apply(source);
    }

    public Object decode(Object source) {
        return this.decode(source.toString());
    }

    private static class InstantTemporalQuery
    implements TemporalQuery<Instant>,
    Serializable {
        private InstantTemporalQuery() {
        }

        @Override
        public Instant queryFrom(TemporalAccessor temporal) {
            return Instant.from(temporal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    private static class LocalDateTimeTemporalQuery
    implements TemporalQuery<LocalDateTime>,
    Serializable {
        private LocalDateTimeTemporalQuery() {
        }

        @Override
        public LocalDateTime queryFrom(TemporalAccessor temporal) {
            return LocalDateTime.from(temporal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }
}

