/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.vcard.Entity;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.VCardParameterFactorySupplier;
import net.fortuna.ical4j.vcard.VCardPropertyFactorySupplier;
import org.apache.commons.codec.DecoderException;
import org.mnode.ical4j.serializer.JsonMapper;
import org.mnode.ical4j.serializer.ParameterMapper;
import org.mnode.ical4j.serializer.ParameterMapperImpl;
import org.mnode.ical4j.serializer.PropertyMapper;

public class VCardMapper
extends JsonDeserializer<Entity>
implements JsonMapper {
    private final PropertyMapper propertyMapper = new PropertyMapperImpl(new VCardPropertyFactorySupplier().get());
    private final ParameterMapper parameterMapper = new ParameterMapperImpl(new VCardParameterFactorySupplier().get());

    public VCardMapper(Class<?> vc) {
    }

    public Entity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Entity entity = new Entity();
        this.assertCurrentToken(p, JsonToken.START_OBJECT);
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            this.assertCurrentToken(p, JsonToken.FIELD_NAME);
            String propertyName = p.currentName();
            try {
                if (JsonToken.START_ARRAY.equals((Object)p.nextToken())) {
                    entity.addAll(this.parsePropertyList(propertyName, p));
                    continue;
                }
                entity.add(this.propertyMapper.map(p));
            }
            catch (URISyntaxException | ParseException | DecoderException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return entity;
    }

    protected List<Property> parsePropertyList(String propertyName, JsonParser p) throws IOException, URISyntaxException, ParseException, DecoderException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            properties.add(new PropertyMapperImpl(new VCardPropertyFactorySupplier().get(), propertyName).map(p));
        }
        return properties;
    }

    private boolean isParameter(String fieldName) {
        return Arrays.asList(ParameterName.PREF).contains(ParameterName.valueOf((String)fieldName));
    }

    class PropertyMapperImpl
    implements PropertyMapper {
        private final List<PropertyFactory<?>> propertyFactories;
        private final String propertyName;

        public PropertyMapperImpl(List<PropertyFactory<?>> propertyFactories) {
            this(propertyFactories, null);
        }

        public PropertyMapperImpl(List<PropertyFactory<?>> propertyFactories, String propertyName) {
            this.propertyFactories = propertyFactories;
            this.propertyName = propertyName;
        }

        @Override
        public Property map(JsonParser p) throws IOException {
            PropertyBuilder builder = new PropertyBuilder(this.propertyFactories);
            builder.name(this.propertyName != null ? this.propertyName : p.currentName());
            if (JsonToken.START_ARRAY.equals((Object)p.currentToken())) {
                StringBuilder b = new StringBuilder();
                while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                    VCardMapper.this.assertCurrentToken(p, JsonToken.VALUE_STRING);
                    b.append(p.getText());
                    b.append(',');
                }
                builder.value(b.toString());
            } else if (JsonToken.START_OBJECT.equals((Object)p.currentToken())) {
                while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                    VCardMapper.this.assertCurrentToken(p, JsonToken.FIELD_NAME);
                    if (VCardMapper.this.isParameter(p.currentName())) {
                        builder.parameter(VCardMapper.this.parameterMapper.map(p));
                        continue;
                    }
                    VCardMapper.this.assertNextScalarValue(p);
                    builder.value(p.getText());
                }
            } else {
                VCardMapper.this.assertCurrentScalarValue(p);
                builder.value(p.getText());
            }
            return builder.build();
        }
    }
}

