/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import net.fortuna.ical4j.model.PropertyListAccessor;
import net.fortuna.ical4j.vcard.Entity;
import net.fortuna.ical4j.vcard.property.Address;
import org.mnode.ical4j.serializer.JsonBuilder;
import org.mnode.ical4j.serializer.jsonld.PostalAddressNodeBuilder;

public abstract class AbstractNodeBuilder<T extends PropertyListAccessor>
implements JsonBuilder {
    private final String schemaType;
    protected T component;

    public AbstractNodeBuilder(String schemaType) {
        this.schemaType = schemaType;
    }

    public AbstractNodeBuilder<T> component(T component) {
        this.component = component;
        return this;
    }

    protected ObjectNode createObjectNode() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("@context", "https://schema.org");
        node.put("@type", this.schemaType);
        return node;
    }

    protected ObjectNode putIfNotAbsent(String propertyName, ObjectNode node, String property) {
        this.component.getProperty(property).ifPresent(value -> node.put(propertyName, value.getValue()));
        return node;
    }

    protected ObjectNode putIfNotAbsent(String propertyName, ObjectNode node, Enum<?> property) {
        this.component.getProperty(property).ifPresent(value -> node.put(propertyName, value.getValue()));
        return node;
    }

    protected ObjectNode setObject(String propertyName, ObjectNode node, String property) {
        Optional prop = this.component.getProperty(property);
        if (prop.isPresent() && prop.get() instanceof Address) {
            JsonNode address = new PostalAddressNodeBuilder().component((Entity)this.component).build();
            node.set(propertyName, address);
        }
        return node;
    }

    protected ObjectNode setObject(String propertyName, ObjectNode node, Enum<?> property) {
        Optional prop = this.component.getProperty(property);
        if (prop.isPresent() && prop.get() instanceof Address) {
            JsonNode address = new PostalAddressNodeBuilder().component((Entity)this.component).build();
            node.set(propertyName, address);
        }
        return node;
    }

    public abstract JsonNode build();
}

