/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.template.groupware;

import java.time.Instant;
import java.time.temporal.Temporal;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.DateTimePropertyModifiers;
import net.fortuna.ical4j.model.DescriptivePropertyModifiers;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.VToDo;
import org.ical4j.template.AbstractTemplate;

public class Action
extends AbstractTemplate<VToDo> {
    private Participant participant;
    private String summary;
    private Temporal due;
    private Instant completed;

    public Action() {
        super(VToDo.class);
    }

    public Action(Class<? extends VToDo> typeClass) {
        super(typeClass);
    }

    public <T extends VToDo> Action(T prototype) {
        super(prototype.getClass());
        this.setPrototype(prototype);
    }

    public Action participant(Participant participant) {
        this.participant = participant;
        return this;
    }

    public Action summary(String summary) {
        this.summary = summary;
        return this;
    }

    public Action due(Temporal due) {
        this.due = due;
        return this;
    }

    @Override
    public VToDo apply(VToDo vToDo) {
        vToDo.with(DateTimePropertyModifiers.COMPLETED, (Object)this.completed);
        vToDo.with(DescriptivePropertyModifiers.SUMMARY, (Object)this.summary);
        vToDo.with(DateTimePropertyModifiers.DUE, (Object)this.due);
        vToDo.with((c, p) -> {
            if (p != null) {
                c.add((Component)p);
            }
            return c;
        }, (Object)this.participant);
        return vToDo;
    }
}

