/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.template.groupware;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.extensions.concept.EventType;
import net.fortuna.ical4j.extensions.property.Repeats;
import net.fortuna.ical4j.model.DateTimePropertyModifiers;
import net.fortuna.ical4j.model.DescriptivePropertyModifiers;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.RecurrencePropertyModifiers;
import net.fortuna.ical4j.model.RelationshipPropertyModifiers;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VLocation;
import net.fortuna.ical4j.model.component.VResource;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.vcard.VCard;
import org.ical4j.template.AbstractTemplate;
import org.ical4j.template.groupware.GroupwarePropertyModifiers;

public class Meeting
extends AbstractTemplate<VEvent> {
    private ZonedDateTime start;
    private TemporalAmount duration;
    private VCard organizer;
    private Uid uid;
    private String summary;
    private String description;
    private Participant chair;
    private final List<Participant> required = new ArrayList<Participant>();
    private final List<Participant> optional = new ArrayList<Participant>();
    private Repeats<ZonedDateTime> repeats;
    private VLocation location;
    private List<VAlarm> notifications = new ArrayList<VAlarm>();
    private VToDo agenda;
    private VResource conference;
    private VResource recording;
    private VResource transcript;

    public Meeting() {
        super(VEvent.class);
    }

    public Meeting(Class<? extends VEvent> typeClass) {
        super(typeClass);
    }

    public <T extends VEvent> Meeting(T prototype) {
        super(prototype.getClass());
        this.setPrototype(prototype);
    }

    public Meeting organizer(VCard card) {
        this.organizer = card;
        return this;
    }

    public Meeting start(ZonedDateTime start) {
        this.start = start;
        return this;
    }

    public Meeting duration(TemporalAmount duration) {
        this.duration = duration;
        return this;
    }

    public Meeting required(Participant participant) {
        this.required.add(participant);
        return this;
    }

    public Meeting optional(Participant participant) {
        this.optional.add(participant);
        return this;
    }

    public Meeting chair(Participant participant) {
        this.chair = participant;
        return this;
    }

    public Meeting repeats(Repeats<ZonedDateTime> repeats) {
        this.repeats = repeats;
        return this;
    }

    public Meeting location(VLocation location) {
        this.location = location;
        return this;
    }

    public Meeting notification(VAlarm notification) {
        this.notifications.add(notification);
        return this;
    }

    public Meeting agenda(VToDo agenda) {
        this.agenda = agenda;
        return this;
    }

    @Override
    public VEvent apply(VEvent vEvent) {
        if (this.getPrototype() != null) {
            ((VEvent)this.getPrototype()).getProperties().forEach(arg_0 -> ((VEvent)vEvent).add(arg_0));
        }
        vEvent.replace((Property)EventType.MEETING);
        vEvent.with(RelationshipPropertyModifiers.UID, (Object)this.uid);
        vEvent.with(RecurrencePropertyModifiers.RRULE, this.repeats);
        vEvent.with(DescriptivePropertyModifiers.SUMMARY, (Object)this.summary);
        vEvent.with(DateTimePropertyModifiers.DTSTART, (Object)this.start);
        vEvent.with(DateTimePropertyModifiers.DURATION, (Object)this.duration);
        vEvent.with(GroupwarePropertyModifiers.ORGANIZER, (Object)this.organizer);
        vEvent.with(GroupwarePropertyModifiers.CHAIR, (Object)this.chair);
        this.required.forEach(p -> vEvent.with(GroupwarePropertyModifiers.REQUIRED_ATTENDEE, p));
        this.optional.forEach(p -> vEvent.with(GroupwarePropertyModifiers.OPTIONAL_ATTENDEE, p));
        this.notifications.forEach(arg_0 -> ((VEvent)vEvent).add(arg_0));
        return vEvent;
    }
}

