/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.renderkit;

import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelector;
import com.icesoft.faces.component.ext.RowSelectorEvent;
import com.icesoft.faces.component.ext.renderkit.TableRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class RowSelectorRenderer
extends DomBasicRenderer {
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        HtmlDataTable dataTable = RowSelectorRenderer.getParentDataTable(uiComponent);
        String dataTableId = dataTable.getClientId(facesContext);
        String selectedRowsParameter = TableRenderer.getSelectedRowParameterName(dataTableId);
        String selectedRows = (String)facesContext.getExternalContext().getRequestParameterMap().get(selectedRowsParameter);
        if (selectedRows == null || selectedRows.trim().length() == 0) {
            selectedRows = (String)facesContext.getExternalContext().getRequestMap().get(RowSelectorRenderer.class.getName());
            if (selectedRows == null || selectedRows.trim().length() == 0) {
                return;
            }
        } else {
            facesContext.getExternalContext().getRequestMap().put(RowSelectorRenderer.class.getName(), selectedRows);
        }
        int rowIndex = dataTable.getRowIndex();
        StringTokenizer st = new StringTokenizer(selectedRows, ",");
        boolean rowClicked = false;
        while (st.hasMoreTokens()) {
            int row = Integer.parseInt(st.nextToken());
            if (row != rowIndex) continue;
            rowClicked = true;
            break;
        }
        RowSelector rowSelector = (RowSelector)uiComponent;
        try {
            if (rowClicked) {
                boolean b = rowSelector.getValue();
                b = !b;
                rowSelector.setValue(new Boolean(b));
                if (rowSelector.getSelectionListener() != null) {
                    RowSelectorEvent evt = new RowSelectorEvent((UIComponent)rowSelector, rowIndex, b);
                    evt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                    rowSelector.queueEvent(evt);
                }
            } else if (Boolean.FALSE.equals(rowSelector.getMultiple())) {
                rowSelector.setValue(Boolean.FALSE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    private static HtmlDataTable getParentDataTable(UIComponent uiComponenent) {
        UIComponent parentComp = uiComponenent.getParent();
        if (parentComp == null) {
            throw new RuntimeException("RowSelectorRenderer: decode. Could not find an Ice:dataTable as a parent componenent");
        }
        if (parentComp instanceof HtmlDataTable) {
            return (HtmlDataTable)parentComp;
        }
        return RowSelectorRenderer.getParentDataTable(parentComp);
    }
}

