/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputdate;

import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.ext.HtmlGraphicImage;
import com.icesoft.faces.component.ext.HtmlOutputText;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.selectinputdate.SelectInputDate;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SelectInputDateRenderer
extends DomBasicInputRenderer {
    private static final Log log = LogFactory.getLog((Class)SelectInputDateRenderer.class);
    private final String CALENDAR_TABLE = "_calendarTable";
    private final String CALENDAR_BUTTON = "_calendarButton";
    private final String CALENDAR_POPUP = "_calendarPopup";
    private final String HIDDEN_FIELD_NAME = "showPopup";
    private final String DATE_SELECTED = "dateSelected";
    private final String PREV_MONTH = "_prevmo";
    private final String NEXT_MONTH = "_nextmo";
    private final String PREV_YEAR = "_prevyr";
    private final String NEXT_YEAR = "_nextyr";
    private final String CALENDAR = "_calendar";
    String[] weekdays = new String[7];
    String[] weekdaysLong = new String[7];
    String[] months = new String[12];
    Locale currentLocale = null;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
    }

    private String getHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent form = SelectInputDateRenderer.findForm((UIComponent)uiComponent);
        String formId = form.getClientId(facesContext);
        String clientId = uiComponent.getClientId(facesContext);
        String hiddenFieldName = formId + ':' + "_id" + clientId + "showPopup";
        return hiddenFieldName;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Date value;
        String clientId;
        this.validateParameters(facesContext, uiComponent, SelectInputDate.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        SelectInputDate selectInputDate = (SelectInputDate)uiComponent;
        UIComponent parentForm = SelectInputDateRenderer.findForm((UIComponent)selectInputDate);
        if (parentForm == null) {
            log.error((Object)"SelectInputDate::must be in a FORM");
            return;
        }
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            boolean popupState = selectInputDate.isShowPopup();
            SelectInputDateRenderer.setRootElementId((FacesContext)facesContext, (Element)root, (UIComponent)uiComponent);
            clientId = uiComponent.getClientId(facesContext);
            if (selectInputDate.isRenderAsPopup()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Render as popup");
                }
                Element dateText = domContext.createElement("input");
                dateText.setAttribute("value", selectInputDate.formatDate((Date)selectInputDate.getValue()));
                dateText.setAttribute("id", clientId + "_calendarInputtext");
                dateText.setAttribute("name", clientId + "_calendarInputtext");
                dateText.setAttribute("class", selectInputDate.getCalendarInputClass());
                dateText.setAttribute("onfocus", "setFocus('');");
                ((Object)((Object)this)).getClass();
                dateText.setAttribute("onkeypress", "iceSubmit(form,this,event);");
                StringBuffer stringBuffer = new StringBuffer().append("setFocus('');");
                ((Object)((Object)this)).getClass();
                dateText.setAttribute("onblur", stringBuffer.append("iceSubmitPartial(form, this, event);").toString());
                if (selectInputDate.getAutocomplete() != null) {
                    dateText.setAttribute("autocomplete", selectInputDate.getAutocomplete());
                }
                String tooltip = selectInputDate.getPopupDateFormat();
                dateText.setAttribute("title", "Date Format: " + tooltip);
                root.appendChild(dateText);
                Element calendarButton = domContext.createElement("input");
                calendarButton.setAttribute("id", clientId + "_calendarButton");
                calendarButton.setAttribute("name", clientId + "_calendarButton");
                calendarButton.setAttribute("type", "image");
                calendarButton.setAttribute("onfocus", "setFocus('');");
                String onClick = "document.forms['" + parentForm.getClientId(facesContext) + "']['" + this.getLinkId(facesContext, uiComponent) + "'].value='" + clientId + "_calendarButton" + "';" + "document.forms['" + parentForm.getClientId(facesContext) + "']['" + this.getHiddenFieldName(facesContext, uiComponent) + "'].value='toggle';" + "iceSubmitPartial( document.forms['" + parentForm.getClientId(facesContext) + "'], this,event); return false;";
                calendarButton.setAttribute("onclick", onClick);
                root.appendChild(calendarButton);
                FormRenderer.addHiddenField((FacesContext)facesContext, (String)this.getHiddenFieldName(facesContext, uiComponent));
                if (!popupState) {
                    String resolvedSrc = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(selectInputDate.getImageDir() + selectInputDate.getOpenPopupImage()));
                    calendarButton.setAttribute("src", resolvedSrc);
                    calendarButton.setAttribute("alt", "Open Popup Calendar");
                    calendarButton.setAttribute("title", "Open Popup Calendar");
                    FormRenderer.addHiddenField((FacesContext)facesContext, (String)(parentForm.getClientId(facesContext) + ":_idcl"));
                    domContext.stepOver();
                    return;
                }
                String resolvedSrc = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(selectInputDate.getImageDir() + selectInputDate.getClosePopupImage()));
                calendarButton.setAttribute("src", resolvedSrc);
                calendarButton.setAttribute("alt", "Close Popup Calendar");
                calendarButton.setAttribute("title", "Close Popup Calendar");
                if (!domContext.isStreamWriting()) {
                    Text br = domContext.createTextNode("<br/>");
                    root.appendChild(br);
                }
                Element calendarDiv = domContext.createElement("div");
                calendarDiv.setAttribute("id", clientId + "_calendarPopup");
                calendarDiv.setAttribute("name", clientId + "_calendarPopup");
                calendarDiv.setAttribute("style", "position:absolute;z-index:10;");
                calendarDiv.setAttribute("title", "A Popup Calendar where a date can be selected.");
                Element table = domContext.createElement("table");
                table.setAttribute("id", clientId + "_calendarTable");
                table.setAttribute("name", clientId + "_calendarTable");
                table.setAttribute("class", selectInputDate.getStyleClass());
                table.setAttribute("style", "position:absolute;");
                table.setAttribute("cellpadding", "0");
                table.setAttribute("cellspacing", "0");
                String mouseOver = selectInputDate.getOnmouseover();
                table.setAttribute("onmouseover", mouseOver);
                String mouseOut = selectInputDate.getOnmouseout();
                table.setAttribute("onmouseout", mouseOut);
                String mouseMove = selectInputDate.getOnmousemove();
                table.setAttribute("onmousemove", mouseMove);
                table.setAttribute("summary", "This table contains a Calendar where a date can be selected.");
                calendarDiv.appendChild(table);
                Text iframe = domContext.createTextNode("<!--[if lte IE 6.5]><iframe src='" + CoreUtils.resolveResourceURL((FacesContext)FacesContext.getCurrentInstance(), (String)"/xmlhttp/blank") + "' class=\"iceSelInpDateIFrameFix\"></iframe><![endif]-->");
                calendarDiv.appendChild(iframe);
                root.appendChild(calendarDiv);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Select input Date Normal");
                }
                Element table = domContext.createElement("table");
                table.setAttribute("id", clientId + "_calendarTable");
                table.setAttribute("name", clientId + "_calendarTable");
                table.setAttribute("class", selectInputDate.getStyleClass());
                table.setAttribute("cellpadding", "0");
                table.setAttribute("cellspacing", "0");
                String mouseOver = selectInputDate.getOnmouseover();
                table.setAttribute("onmouseover", mouseOver);
                String mouseOut = selectInputDate.getOnmouseout();
                table.setAttribute("onmouseout", mouseOut);
                String mouseMove = selectInputDate.getOnmousemove();
                table.setAttribute("onmousemove", mouseMove);
                table.setAttribute("summary", "This table contains a Calendar where a date can be selected.");
                root.appendChild(table);
            }
        }
        clientId = uiComponent.getClientId(facesContext);
        this.currentLocale = facesContext.getViewRoot().getLocale();
        if (selectInputDate.isNavEvent()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Rendering Nav Event");
            }
            value = selectInputDate.getNavDate();
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Logging non nav event");
            }
            try {
                Converter converter = this.getConverter((UIInput)selectInputDate);
                value = converter instanceof DateConverter ? ((DateConverter)converter).getAsDate(facesContext, uiComponent) : CustomComponentUtils.getDateValue((UIComponent)selectInputDate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                value = null;
            }
        }
        Calendar timeKeeper = Calendar.getInstance(this.currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        DateFormatSymbols symbols = new DateFormatSymbols(this.currentLocale);
        this.weekdays = SelectInputDateRenderer.mapWeekdays(symbols);
        this.weekdaysLong = SelectInputDateRenderer.mapWeekdaysLong(symbols);
        this.months = SelectInputDateRenderer.mapMonths(symbols);
        int lastDayInMonth = timeKeeper.getActualMaximum(5);
        int currentDay = timeKeeper.get(5);
        if (currentDay > lastDayInMonth) {
            currentDay = lastDayInMonth;
        }
        Object currentValue = selectInputDate.getValue();
        timeKeeper.set(5, 1);
        int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(timeKeeper.get(7));
        int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(timeKeeper.getFirstDayOfWeek());
        ResponseWriter writer = facesContext.getResponseWriter();
        Element root = (Element)domContext.getRootNode();
        if (selectInputDate.isRenderAsPopup()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"SelectInputDate as Popup");
            }
            Element dateText = (Element)root.getFirstChild();
            if (currentValue != null) {
                dateText.setAttribute("value", selectInputDate.formatDate((Date)currentValue));
            }
            NodeList tables = root.getElementsByTagName("table");
            Element table = (Element)tables.item(0);
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
            Element tr1 = domContext.createElement("tr");
            table.appendChild(tr1);
            this.writeMonthYearHeader(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, this.weekdays, this.months, tr1, selectInputDate.getMonthYearRowClass());
            Element tr2 = domContext.createElement("tr");
            table.appendChild(tr2);
            this.writeWeekDayNameHeader(domContext, weekStartsAtDayIndex, this.weekdays, facesContext, writer, (UIInput)selectInputDate, tr2, selectInputDate.getWeekRowClass());
            this.writeDays(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, this.weekdays, table);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"renderNormal::endcodeEnd");
            }
            Element table = (Element)root.getFirstChild();
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
            Element tr1 = domContext.createElement("tr");
            table.appendChild(tr1);
            this.writeMonthYearHeader(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, this.weekdays, this.months, tr1, selectInputDate.getMonthYearRowClass());
            Element tr2 = domContext.createElement("tr");
            this.writeWeekDayNameHeader(domContext, weekStartsAtDayIndex, this.weekdays, facesContext, writer, (UIInput)selectInputDate, tr2, selectInputDate.getWeekRowClass());
            table.appendChild(tr2);
            this.writeDays(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, this.weekdays, table);
        }
        selectInputDate.getChildren().removeAll(selectInputDate.getChildren());
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void writeMonthYearHeader(DOMContext domContext, FacesContext facesContext, ResponseWriter writer, SelectInputDate inputComponent, Calendar timeKeeper, int currentDay, String[] weekdays, String[] months, Element headerTr, String styleClass) throws IOException {
        Element table = domContext.createElement("table");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("width", "100%");
        table.setAttribute("summary", "Month Year navigation header");
        Element tr = domContext.createElement("tr");
        Element headertd = domContext.createElement("td");
        table.appendChild(tr);
        headertd.appendChild(table);
        headerTr.appendChild(headertd);
        headertd.setAttribute("colspan", "7");
        Calendar cal = this.shiftMonth(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, "<", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMovePreviousImage(), -1);
        Element td = domContext.createElement("td");
        td.setAttribute("class", styleClass);
        td.setAttribute("width", "40%");
        Text text = domContext.createTextNode(months[timeKeeper.get(2)] + "");
        td.appendChild(text);
        tr.appendChild(td);
        cal = this.shiftMonth(facesContext, timeKeeper, currentDay, 1);
        int calYear = cal.get(1);
        if (inputComponent.getHightlightRules().containsKey("1$" + calYear)) {
            inputComponent.setHighlightYearClass(inputComponent.getHightlightRules().get("1$" + calYear) + " ");
        } else {
            inputComponent.setHighlightYearClass("");
        }
        int calMonth = cal.get(2);
        if (inputComponent.getHightlightRules().containsKey("2$" + calMonth)) {
            inputComponent.setHighlightMonthClass(inputComponent.getHightlightRules().get("2$" + calMonth) + " ");
        } else {
            inputComponent.setHighlightMonthClass("");
        }
        this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, ">", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMoveNextImage(), -1);
        Element emptytd = domContext.createElement("td");
        emptytd.setAttribute("class", styleClass);
        Text emptytext = domContext.createTextNode("");
        emptytd.appendChild(emptytext);
        tr.appendChild(emptytd);
        cal = this.shiftYear(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, "<<", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMovePreviousImage(), -1);
        Element yeartd = domContext.createElement("td");
        yeartd.setAttribute("class", styleClass);
        Text yeartext = domContext.createTextNode("" + timeKeeper.get(1));
        yeartd.appendChild(yeartext);
        tr.appendChild(yeartd);
        cal = this.shiftYear(facesContext, timeKeeper, currentDay, 1);
        this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, ">>", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMoveNextImage(), -1);
    }

    private Calendar shiftMonth(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(2, cal.get(2) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar shiftYear(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(1, cal.get(1) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar copyCalendar(FacesContext facesContext, Calendar timeKeeper) {
        Calendar cal = Calendar.getInstance(facesContext.getViewRoot().getLocale());
        cal = (Calendar)timeKeeper.clone();
        return cal;
    }

    private void writeWeekDayNameHeader(DOMContext domContext, int weekStartsAtDayIndex, String[] weekdays, FacesContext facesContext, ResponseWriter writer, UIInput inputComponent, Element tr, String styleClass) throws IOException {
        int i;
        for (i = weekStartsAtDayIndex; i < weekdays.length; ++i) {
            this.writeCell(domContext, facesContext, writer, inputComponent, weekdays[i], null, styleClass, tr, null, i);
        }
        for (i = 0; i < weekStartsAtDayIndex; ++i) {
            this.writeCell(domContext, facesContext, writer, inputComponent, weekdays[i], null, styleClass, tr, null, i);
        }
    }

    private void writeDays(DOMContext domContext, FacesContext facesContext, ResponseWriter writer, SelectInputDate inputComponent, Calendar timeKeeper, int currentDay, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, String[] weekdays, Element table) throws IOException {
        int i;
        int space;
        int n = space = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : weekdays.length - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (space == weekdays.length) {
            space = 0;
        }
        int columnIndexCounter = 0;
        Element tr1 = null;
        for (int i2 = 0; i2 < space; ++i2) {
            if (columnIndexCounter == 0) {
                tr1 = domContext.createElement("tr");
                table.appendChild(tr1);
            }
            this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass(), tr1, null, i2);
            ++columnIndexCounter;
        }
        Element tr2 = null;
        for (i = 0; i < lastDayInMonth; ++i) {
            if (columnIndexCounter == 0) {
                tr2 = domContext.createElement("tr");
                table.appendChild(tr2);
            }
            Calendar cal = this.copyCalendar(facesContext, timeKeeper);
            cal.set(5, i + 1);
            int day = 0;
            int month = 0;
            int year = 0;
            try {
                Date currentDate = (Date)inputComponent.getValue();
                Calendar current = Calendar.getInstance();
                current.setTime(currentDate);
                day = current.get(5);
                month = current.get(2);
                year = current.get(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (inputComponent.getHightlightRules().size() > 0) {
                int weekOfYear = cal.get(3);
                int weekOfMonth = cal.get(4);
                int date = cal.get(5);
                int dayOfYear = cal.get(6);
                int dayOfWeek = cal.get(7);
                int dayOfWeekInMonth = cal.get(8);
                if (inputComponent.getHightlightRules().containsKey("3$" + weekOfYear)) {
                    inputComponent.addHighlightWeekClass(String.valueOf(inputComponent.getHightlightRules().get("3$" + weekOfYear)));
                }
                if (inputComponent.getHightlightRules().containsKey("4$" + weekOfMonth)) {
                    inputComponent.addHighlightWeekClass(String.valueOf(inputComponent.getHightlightRules().get("4$" + weekOfMonth)));
                }
                if (inputComponent.getHightlightRules().containsKey("5$" + date)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("5$" + date)));
                }
                if (inputComponent.getHightlightRules().containsKey("6$" + dayOfYear)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("6$" + dayOfYear)));
                }
                if (inputComponent.getHightlightRules().containsKey("7$" + dayOfWeek)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("7$" + dayOfWeek)));
                }
                if (inputComponent.getHightlightRules().containsKey("8$" + dayOfWeekInMonth)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("8$" + dayOfWeekInMonth)));
                }
            }
            String cellStyle = inputComponent.getHighlightDayCellClass() + inputComponent.getDayCellClass();
            if (cal.get(5) == day && cal.get(2) == month && cal.get(1) == year) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            if (cal.get(5) == day && cal.get(2) == month && cal.get(1) == year) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            if (tr2 == null) {
                this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle, tr1, null, i);
            } else {
                this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle, tr2, null, i);
            }
            if (++columnIndexCounter == weekdays.length) {
                columnIndexCounter = 0;
            }
            inputComponent.resetHighlightClasses(3);
        }
        if (columnIndexCounter != 0 && tr2 != null) {
            for (i = columnIndexCounter; i < weekdays.length; ++i) {
                this.writeCell(domContext, facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass(), tr2, null, i);
            }
        }
    }

    private void writeCell(DOMContext domContext, FacesContext facesContext, ResponseWriter writer, UIInput component, String content, Date valueForLink, String styleClass, Element tr, String imgSrc, int weekDayIndex) throws IOException {
        Element td = domContext.createElement("td");
        tr.appendChild(td);
        if (styleClass != null) {
            td.setAttribute("class", styleClass);
        }
        if (valueForLink == null) {
            Text text = domContext.createTextNode(content);
            td.setAttribute("title", this.weekdaysLong[weekDayIndex]);
            td.appendChild(text);
        } else {
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, (UIComponent)component, domContext.getRootNode(), (Node)td);
            this.writeLink(content, component, facesContext, valueForLink, styleClass, imgSrc, td);
            domContext.stepOver();
        }
    }

    private void writeLink(String content, UIInput component, FacesContext facesContext, Date valueForLink, String styleClass, String imgSrc, Element td) throws IOException {
        Converter converter = this.getConverter(component);
        HtmlCommandLink link = new HtmlCommandLink();
        Calendar cal = Calendar.getInstance(this.currentLocale);
        cal.setTime(valueForLink);
        String month = this.months[cal.get(2)];
        String year = String.valueOf(cal.get(1));
        int dayInt = cal.get(7);
        dayInt = this.mapCalendarDayToCommonDay(dayInt);
        String day = this.weekdaysLong[dayInt];
        String altText = "";
        if (content.equals("<")) {
            link.setId(component.getId() + this.PREV_MONTH);
            altText = "Move to previous month " + month;
        } else if (content.equals(">")) {
            link.setId(component.getId() + this.NEXT_MONTH);
            altText = "Move to next month " + month;
        } else if (content.equals(">>")) {
            link.setId(component.getId() + this.NEXT_YEAR);
            altText = "Move to next year " + year;
        } else if (content.equals("<<")) {
            link.setId(component.getId() + this.PREV_YEAR);
            altText = "Move to previous year " + year;
        } else {
            link.setId(component.getId() + "_" + content.hashCode() + this.CALENDAR);
            if (log.isDebugEnabled()) {
                log.debug((Object)("linkId=" + component.getId() + "_" + content.hashCode() + this.CALENDAR));
            }
        }
        link.setPartialSubmit(true);
        link.setTransient(true);
        link.setImmediate(component.isImmediate());
        if (imgSrc != null) {
            HtmlGraphicImage img = new HtmlGraphicImage();
            img.setUrl(imgSrc);
            img.setHeight("16");
            img.setWidth("17");
            img.setStyle("border:none;");
            img.setAlt(altText);
            img.setId(component.getId() + "_" + content.hashCode() + "_img");
            img.setTransient(true);
            link.getChildren().add(img);
        } else {
            HtmlOutputText text = new HtmlOutputText();
            text.setValue(content);
            text.setId(component.getId() + "_" + content.hashCode() + "_text");
            text.setTransient(true);
            text.setTitle(day);
            link.getChildren().add(text);
        }
        UIParameter parameter = new UIParameter();
        parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_param");
        parameter.setTransient(true);
        parameter.setName(component.getClientId(facesContext));
        parameter.setValue((Object)converter.getAsString(facesContext, (UIComponent)component, (Object)valueForLink));
        component.getChildren().add(link);
        link.getChildren().add(parameter);
        if (!(content.equals("<") || content.equals(">") || content.equals(">>") || content.equals("<<"))) {
            parameter = new UIParameter();
            parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_" + "dateSelected");
            parameter.setName(this.getHiddenFieldName(facesContext, (UIComponent)component));
            parameter.setValue((Object)"false");
            link.getChildren().add(parameter);
        }
        link.encodeBegin(facesContext);
        link.encodeChildren(facesContext);
        link.encodeEnd(facesContext);
        td.setAttribute("id", link.getClientId(facesContext) + "td");
        try {
            Integer.parseInt(content);
            ((SelectInputDate)component).getLinkMap().put(link.getClientId(facesContext), td);
            if (styleClass.equals("iceSelInpDateCur")) {
                ((SelectInputDate)component).setSelectedDayLink(link.getClientId(facesContext));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private Converter getConverter(UIInput component) {
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        return converter;
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    private static String[] mapWeekdaysLong(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    public static String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public String getLinkId(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent form = SelectInputDateRenderer.findForm((UIComponent)uiComponent);
        String formId = form.getClientId(facesContext);
        return formId + ":_idcl";
    }

    private boolean checkLink(String clickedLink, String clientId) {
        if (clickedLink == null) {
            return false;
        }
        boolean found = false;
        String REGEX = clientId;
        String INPUT = clickedLink;
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(INPUT);
        while (matcher.find()) {
            found = true;
        }
        return found;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        this.validateParameters(facesContext, component, SelectInputDate.class);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String linkId = this.getLinkId(facesContext, component);
        Object clickedLink = requestParameterMap.get(linkId);
        String clientId = component.getClientId(facesContext);
        Map parameter = facesContext.getExternalContext().getRequestParameterMap();
        String param = (String)parameter.get(component.getClientId(facesContext));
        if (clickedLink != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("linkId::" + linkId + "  clickedLink::" + clickedLink + "  clientId::" + clientId));
            }
            if (this.checkLink((String)clickedLink, clientId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"---------------------------------");
                    log.debug((Object)"----------START::DECODE----------");
                    log.debug((Object)"---------------------------------");
                    log.debug((Object)("decode::linkId::" + linkId + "=" + clickedLink + " clientId::" + clientId));
                }
                if (((String)clickedLink).endsWith(this.PREV_MONTH) || ((String)clickedLink).endsWith(this.NEXT_MONTH) || ((String)clickedLink).endsWith(this.PREV_YEAR) || ((String)clickedLink).endsWith(this.NEXT_YEAR)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-------------Navigation Event-------------");
                    }
                    this.decodeNavigation(facesContext, component);
                } else if (((String)clickedLink).endsWith(this.CALENDAR)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-------------Select Date Event-------------");
                    }
                    this.decodeSelectDate(facesContext, component);
                } else if (((String)clickedLink).endsWith(this.CALENDAR_BUTTON)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-------------Popup Event-------------------");
                    }
                    this.decodePopup(facesContext, component);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-------------InputText enterkey Event ??----");
                }
                this.decodeInputText(facesContext, component);
            }
        }
    }

    private void decodeNavigation(FacesContext facesContext, UIComponent component) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        SelectInputDate dateSelect = (SelectInputDate)component;
        if (log.isDebugEnabled()) {
            log.debug((Object)"setNavDate::");
            log.debug((Object)"#################################");
        }
        dateSelect.setNavEvent(true);
        dateSelect.setNavDate((Date)this.getConvertedValue(facesContext, (UIComponent)dateSelect, requestParameterMap.get(dateSelect.getClientId(facesContext))));
    }

    private void decodePopup(FacesContext facesContext, UIComponent component) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String popupState = this.getHiddenFieldName(facesContext, component);
        String showPopup = (String)requestParameterMap.get(popupState);
        SelectInputDate dateSelect = (SelectInputDate)component;
        if (log.isDebugEnabled()) {
            log.debug((Object)("decodePopup::" + showPopup));
            log.debug((Object)"#################################");
        }
        if (showPopup != null) {
            dateSelect.setShowPopup(!dateSelect.isShowPopup());
        }
        dateSelect.setNavEvent(false);
    }

    private void decodeSelectDate(FacesContext facesContext, UIComponent component) {
        String inputTextDateId;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String popupState = this.getHiddenFieldName(facesContext, component);
        String showPopup = (String)requestParameterMap.get(popupState);
        SelectInputDate dateSelect = (SelectInputDate)component;
        if (log.isDebugEnabled()) {
            log.debug((Object)("selectDate::showPopup" + showPopup));
            log.debug((Object)"#################################");
        }
        if (showPopup != null) {
            if (showPopup.equalsIgnoreCase("true")) {
                dateSelect.setShowPopup(true);
            } else {
                dateSelect.setShowPopup(false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"decodeUIInput::");
            log.debug((Object)"#################################");
        }
        if (requestParameterMap.containsKey(inputTextDateId = component.getClientId(facesContext) + "_calendarInputtext")) {
            ((BridgeFacesContext)facesContext).setFocusId(inputTextDateId);
        }
        CustomComponentUtils.decodeUIInput(facesContext, component);
        dateSelect.setNavEvent(false);
    }

    private void decodeInputText(FacesContext facesContext, UIComponent component) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String popupState = this.getHiddenFieldName(facesContext, component);
        String showPopup = (String)requestParameterMap.get(popupState);
        SelectInputDate dateSelect = (SelectInputDate)component;
        String clientId = dateSelect.getClientId(facesContext);
        String linkId = this.getLinkId(facesContext, component);
        Object clickedLink = requestParameterMap.get(linkId);
        String inputTextDateId = component.getClientId(facesContext) + "_calendarInputtext";
        Object inputTextDate = requestParameterMap.get(inputTextDateId);
        if (requestParameterMap.containsKey(inputTextDateId) && dateSelect.isRenderAsPopup()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"decoding InputText EnterKey::");
                log.debug((Object)"###################################");
            }
            if (showPopup != null) {
                if (this.checkLink((String)clickedLink, clientId)) {
                    if (showPopup.equalsIgnoreCase("true")) {
                        dateSelect.setShowPopup(true);
                    } else {
                        dateSelect.setShowPopup(false);
                    }
                }
                if (String.valueOf(inputTextDate).equals("")) {
                    dateSelect.setSubmittedValue("null");
                } else {
                    dateSelect.setSubmittedValue(inputTextDate);
                }
            }
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        this.validateParameters(facesContext, uiComponent, SelectInputDate.class);
        CalendarDateTimeConverter converter = new CalendarDateTimeConverter();
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        Object o = converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
        return o;
    }

    public static class CalendarDateTimeConverter
    implements Converter {
        public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
            if (s == null || s.trim().length() == 0) {
                return null;
            }
            if ("null".equals(s)) {
                return null;
            }
            SimpleDateFormat dateFormat = null;
            if (uiComponent instanceof SelectInputDate && ((SelectInputDate)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((SelectInputDate)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(popupDateFormat);
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            try {
                return dateFormat.parse(s);
            }
            catch (ParseException e) {
                ConverterException ex = new ConverterException((Throwable)e);
                throw ex;
            }
        }

        public static String createJSPopupFormat(FacesContext facesContext, String popupDateFormat) {
            if (popupDateFormat == null) {
                SimpleDateFormat defaultDateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
                popupDateFormat = defaultDateFormat.toPattern();
            }
            StringBuffer jsPopupDateFormat = new StringBuffer();
            for (int i = 0; i < popupDateFormat.length(); ++i) {
                char c = popupDateFormat.charAt(i);
                if (c == 'M') {
                    jsPopupDateFormat.append('M');
                    continue;
                }
                if (c == 'd') {
                    jsPopupDateFormat.append('d');
                    continue;
                }
                if (c == 'y') {
                    jsPopupDateFormat.append('y');
                    continue;
                }
                if (c == ' ') {
                    jsPopupDateFormat.append(' ');
                    continue;
                }
                if (c == '.') {
                    jsPopupDateFormat.append('.');
                    continue;
                }
                if (c != '/') continue;
                jsPopupDateFormat.append('/');
            }
            return jsPopupDateFormat.toString().trim();
        }

        public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
            Date date = (Date)o;
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = null;
            if (uiComponent instanceof SelectInputDate && ((SelectInputDate)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((SelectInputDate)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(popupDateFormat);
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            return dateFormat.format(date);
        }

        private static SimpleDateFormat createStandardDateFormat(FacesContext facesContext) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, facesContext.getViewRoot().getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                return new SimpleDateFormat("dd.MM.yyyy");
            }
            return new SimpleDateFormat("dd.MM.yyyy");
        }
    }

    public static interface DateConverter
    extends Converter {
        public Date getAsDate(FacesContext var1, UIComponent var2);
    }
}

