/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.datapaginator;

import com.icesoft.faces.component.datapaginator.DataPaginator;
import com.icesoft.faces.component.datapaginator.PaginatorActionEvent;
import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataPaginatorRenderer
extends DomBasicRenderer {
    public static final String RENDERER_TYPE = "com.icesoft.faces.DataScroller";
    protected static final String PAGE_NAVIGATION = "idx".intern();

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.validateParameters(context, component, DataPaginator.class);
        Map parameter = context.getExternalContext().getRequestParameterMap();
        String param = (String)parameter.get(component.getClientId(context));
        if (param != null && param.length() >= PAGE_NAVIGATION.length()) {
            if (param.startsWith(PAGE_NAVIGATION)) {
                component.queueEvent((FacesEvent)new PaginatorActionEvent(component, Integer.parseInt(param.substring(PAGE_NAVIGATION.length(), param.length()))));
            } else {
                component.queueEvent((FacesEvent)new PaginatorActionEvent(component, param));
            }
        }
    }

    protected void setVariables(FacesContext facescontext, DataPaginator scroller) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            int pageCount = scroller.getPageCount();
            requestMap.put(pageCountVar, new Integer(pageCount));
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            int pageIndex = scroller.getPageIndex();
            if (pageIndex > scroller.getPageCount()) {
                pageIndex = scroller.getPageCount();
            }
            requestMap.put(pageIndexVar, new Integer(pageIndex));
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            int rowsCount = scroller.getRowCount();
            requestMap.put(rowsCountVar, new Integer(rowsCount));
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            int max;
            int displayedRowsCount = scroller.getRows();
            if (displayedRowsCount > (max = scroller.getRowCount() - scroller.getFirstRow())) {
                displayedRowsCount = max;
            }
            requestMap.put(displayedRowsCountVar, new Integer(displayedRowsCount));
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            int firstRowIndex = scroller.getFirstRow();
            if (scroller.getRowCount() > 0) {
                ++firstRowIndex;
            }
            requestMap.put(firstRowIndexVar, new Integer(firstRowIndex));
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            int count;
            int lastRowIndex = scroller.getFirstRow() + scroller.getRows();
            if (lastRowIndex > (count = scroller.getRowCount())) {
                lastRowIndex = count;
            }
            requestMap.put(lastRowIndexVar, new Integer(lastRowIndex));
        }
    }

    public void removeVariables(FacesContext facescontext, UIComponent uiComponent) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        DataPaginator scroller = (DataPaginator)uiComponent;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            requestMap.remove(pageCountVar);
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            requestMap.remove(pageIndexVar);
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            requestMap.remove(rowsCountVar);
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            requestMap.remove(displayedRowsCountVar);
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            requestMap.remove(firstRowIndexVar);
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            requestMap.remove(lastRowIndexVar);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, DataPaginator.class);
        DataPaginator scroller = (DataPaginator)uiComponent;
        if (!scroller.isModelResultSet()) {
            super.encodeBegin(facesContext, uiComponent);
            List kids = scroller.getChildren();
            for (int i = 0; i < kids.size(); ++i) {
                UIComponent kid = (UIComponent)kids.get(i);
                if (kid.getFamily().equalsIgnoreCase("javax.faces.Output")) continue;
                scroller.getChildren().remove(kids.get(i));
            }
            scroller.getUIData().setValue(null);
            scroller.getUIData().setRowIndex(-1);
            this.setVariables(facesContext, scroller);
        }
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
        this.validateParameters(facescontext, uicomponent, DataPaginator.class);
        DataPaginator scroller = (DataPaginator)uicomponent;
        if (!scroller.isModelResultSet()) {
            boolean singlePageScroller;
            boolean bl = singlePageScroller = scroller.getPageCount() <= 1 && scroller.getRowsCountVar() == null && scroller.getDisplayedRowsCountVar() == null;
            if (!singlePageScroller) {
                CustomComponentUtils.renderChildren(facescontext, uicomponent);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, DataPaginator.class);
        DataPaginator scroller = (DataPaginator)uiComponent;
        if (scroller.getUIData() == null) {
            return;
        }
        this.renderScroller(facesContext, uiComponent);
        if (!scroller.isModelResultSet()) {
            this.removeVariables(facesContext, uiComponent);
        }
    }

    protected void renderScroller(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element td;
        Element table;
        DataPaginator scroller = (DataPaginator)uiComponent;
        if (!scroller.isModelResultSet() && !scroller.isRenderFacetsIfSinglePage() && scroller.getPageCount() <= 1) {
            return;
        }
        if (scroller.getFacets().size() <= 0) {
            return;
        }
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)scroller);
        if (!domContext.isInitialized()) {
            table = domContext.createRootElement("table");
            DataPaginatorRenderer.setRootElementId((FacesContext)facesContext, (Element)table, (UIComponent)scroller);
            if (PassThruAttributeRenderer.passThruAttributeExists((UIComponent)scroller)) {
                PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)scroller, null);
            }
        }
        table = (Element)domContext.getRootNode();
        DOMContext.removeChildren((Node)table);
        Element tr = domContext.createElement("tr");
        table.appendChild(tr);
        String styleClass = scroller.getStyleClass();
        table.setAttribute("class", styleClass);
        String style = scroller.getStyle();
        if (style != null && style.length() > 0) {
            table.setAttribute("style", style);
        } else {
            table.removeAttribute("style");
        }
        String scrollButtonCellClass = scroller.getscrollButtonCellClass();
        UIComponent facetComp = scroller.getFirst();
        if (facetComp != null) {
            td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
            this.renderFacet(facesContext, scroller, facetComp, DataPaginator.FACET_FIRST);
        }
        if ((facetComp = scroller.getFastRewind()) != null) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
            this.renderFacet(facesContext, scroller, facetComp, DataPaginator.FACET_FAST_REWIND);
        }
        if ((facetComp = scroller.getPrevious()) != null) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
            this.renderFacet(facesContext, scroller, facetComp, DataPaginator.FACET_PREVIOUS);
        }
        if (!scroller.isModelResultSet() && scroller.isPaginator()) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            td = domContext.createElement("td");
            tr.appendChild(td);
            Element paginatorTable = domContext.createElement("table");
            td.appendChild(paginatorTable);
            this.renderPaginator(facesContext, uiComponent, paginatorTable, domContext);
        }
        if ((facetComp = scroller.getNext()) != null) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
            this.renderFacet(facesContext, scroller, facetComp, DataPaginator.FACET_NEXT);
        }
        if ((facetComp = scroller.getFastForward()) != null) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
            this.renderFacet(facesContext, scroller, facetComp, DataPaginator.FACET_FAST_FORWARD);
        }
        if ((facetComp = scroller.getLast()) != null) {
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                table.appendChild(tr);
            }
            td = domContext.createElement("td");
            td.setAttribute("class", scrollButtonCellClass);
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
            this.renderFacet(facesContext, scroller, facetComp, DataPaginator.FACET_LAST);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    protected void renderFacet(FacesContext facesContext, DataPaginator scroller, UIComponent facetComp, String facetName) throws IOException {
        HtmlCommandLink link = this.getLink(facesContext, scroller, facetName);
        if (scroller.isDisabled() || !scroller.isModelResultSet() && scroller.getPageCount() <= 1) {
            link.setDisabled(true);
        } else {
            link.setDisabled(false);
        }
        link.encodeBegin(facesContext);
        facetComp.encodeBegin(facesContext);
        if (facetComp.getRendersChildren()) {
            facetComp.encodeChildren(facesContext);
        }
        facetComp.encodeEnd(facesContext);
        link.encodeEnd(facesContext);
    }

    protected void renderPaginator(FacesContext facesContext, UIComponent uiComponent, Element paginatorTable, DOMContext domContext) throws IOException {
        int start;
        int pages;
        int pageCount;
        DataPaginator scroller = (DataPaginator)uiComponent;
        int maxPages = scroller.getPaginatorMaxPages();
        if (maxPages <= 1) {
            maxPages = 2;
        }
        if ((pageCount = scroller.getPageCount()) <= 1) {
            return;
        }
        int pageIndex = scroller.getPageIndex();
        if (pageIndex > pageCount) {
            pageIndex = pageCount;
        }
        int delta = maxPages / 2;
        if (pageCount > maxPages && pageIndex > delta) {
            pages = maxPages;
            start = pageIndex - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        String styleClass = scroller.getPaginatorTableClass();
        paginatorTable.setAttribute("class", styleClass);
        Element tr = null;
        if (!scroller.isVertical()) {
            tr = domContext.createElement("tr");
            paginatorTable.appendChild(tr);
        }
        UIComponent form = DataPaginatorRenderer.findForm((UIComponent)scroller);
        String formId = null;
        if (form == null) {
            throw new FacesException("Form tag is missing");
        }
        formId = form.getClientId(facesContext);
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            int idx = i + 1;
            if (scroller.isVertical()) {
                tr = domContext.createElement("tr");
                paginatorTable.appendChild(tr);
            }
            Element td = domContext.createElement("td");
            tr.appendChild(td);
            domContext.setCursorParent((Node)td);
            String cStyleClass = idx == pageIndex ? scroller.getPaginatorActiveColumnClass() : scroller.getPaginatorColumnClass();
            if (cStyleClass != null) {
                td.setAttribute("class", cStyleClass);
            }
            Element link = this.getLink(facesContext, domContext, scroller, Integer.toString(idx), idx, formId);
            td.appendChild(link);
        }
    }

    protected Element getLink(FacesContext facesContext, DOMContext domContext, DataPaginator scroller, String text, int pageIndex, String formId) {
        Element link = domContext.createElement("a");
        if (text != null) {
            link.appendChild(domContext.createTextNode(text));
        }
        String linkid = scroller.getClientId(facesContext) + PAGE_NAVIGATION + Integer.toString(pageIndex);
        String onClick = "document.forms['" + formId + "']['" + scroller.getClientId(facesContext) + "'].value='" + PAGE_NAVIGATION + text + "'" + ";iceSubmit(" + " document.forms['" + formId + "']," + " this,event); " + "return false;";
        link.setAttribute("id", linkid);
        if (scroller.isDisabled()) {
            link.removeAttribute("onclick");
        } else {
            link.setAttribute("onclick", onClick);
        }
        link.setAttribute("href", "#");
        PassThruAttributeRenderer.renderOnFocus((UIComponent)scroller, (Element)link);
        PassThruAttributeRenderer.renderOnBlur((Element)link);
        return link;
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, DataPaginator scroller, String facetName) {
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("com.icesoft.faces.HtmlCommandLink");
        link.setId(scroller.getId() + facetName);
        link.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(scroller.getId() + facetName + "_param");
        parameter.setTransient(true);
        parameter.setName(scroller.getClientId(facesContext));
        parameter.setValue((Object)facetName);
        List children = link.getChildren();
        children.add(parameter);
        scroller.getChildren().add(link);
        return link;
    }
}

