/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.renderkit;

import com.icesoft.faces.component.ext.ColumnGroup;
import com.icesoft.faces.component.ext.HeaderRow;
import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelector;
import com.icesoft.faces.component.ext.UIColumn;
import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.panelseries.UISeries;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableRenderer
extends com.icesoft.faces.renderkit.dom_html_basic.TableRenderer {
    private static final String SELECTED_ROWS = "sel_rows";

    public String getComponentStyleClass(UIComponent uiComponent) {
        return (String)uiComponent.getAttributes().get("styleClass");
    }

    public String getHeaderClass(UIComponent component) {
        return (String)component.getAttributes().get("headerClass");
    }

    public String getFooterClass(UIComponent component) {
        return (String)component.getAttributes().get("footerClass");
    }

    public String[] getRowStyles(UIComponent uiComponent) {
        if (this.getRowStyleClasses(uiComponent).length <= 0) {
            String[] rowStyles = new String[]{Util.getQualifiedStyleClass(uiComponent, "Row1"), Util.getQualifiedStyleClass(uiComponent, "Row2")};
            return rowStyles;
        }
        return this.getRowStyleClasses(uiComponent);
    }

    public String[] getHeaderStyles(UIComponent uiComponent) {
        String headerClass = this.getHeaderClass(uiComponent).replaceAll("iceDatTblHdr", "");
        if (this.getHeaderStyleClasses(uiComponent).length <= 0) {
            String[] headerStyles = new String[]{Util.getQualifiedStyleClass(uiComponent, "ColHdr1") + (headerClass.length() > 0 ? headerClass : ""), Util.getQualifiedStyleClass(uiComponent, "ColHdr2") + (headerClass.length() > 0 ? headerClass : "")};
            return headerStyles;
        }
        return this.getHeaderStyleClasses(uiComponent);
    }

    public void writeColStyles(String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, Element td, int colNumber, UIComponent uiComponent) {
        if (columnStyles.length > 0 && columnStylesMaxIndex >= 0) {
            td.setAttribute("class", columnStyles[columnStyleIndex]);
        }
    }

    protected void renderFacet(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext, boolean header) throws IOException {
        String facetClass;
        String element;
        String tag;
        String facet;
        if (header) {
            facet = "header";
            tag = "thead";
            element = "th";
            facetClass = this.getHeaderClass(uiComponent);
        } else {
            facet = "footer";
            tag = "tfoot";
            element = "td";
            facetClass = this.getFooterClass(uiComponent);
        }
        UISeries uiData = (UISeries)uiComponent;
        uiData.setRowIndex(-1);
        Element root = (Element)domContext.getRootNode();
        if (this.isScrollable(uiComponent)) {
            if (header) {
                root = this.getScrollableHeaderTableElement(root);
                ((Element)root.getParentNode()).setAttribute("class", Util.getQualifiedStyleClass(uiComponent, "ScrlSpr"));
            } else {
                root = this.getScrollableBodyTableElement(root);
            }
        }
        UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)uiData, (String)facet);
        boolean childHeaderFacetExists = this.childColumnHasFacetWithName((UIComponent)uiData, facet);
        Element thead = null;
        if (headerFacet != null || childHeaderFacetExists) {
            thead = domContext.createElement(tag);
            root.appendChild(thead);
            if (header) {
                if (CoreUtils.getPortletStyleClass((String)"portlet-section-header").length() > 1) {
                    thead.setAttribute("class", "portlet-section-header");
                }
                this.renderTableHeader(facesContext, uiComponent, headerFacet, thead, facetClass, element);
                this.renderColumnGroup(facesContext, uiComponent, headerFacet, thead, facetClass, element);
                if (childHeaderFacetExists) {
                    this.renderColumnHeader(facesContext, uiComponent, thead, facet, element, header);
                }
            } else {
                if (CoreUtils.getPortletStyleClass((String)"portlet-section-footer").length() > 1) {
                    thead.setAttribute("class", "portlet-section-footer");
                }
                if (childHeaderFacetExists) {
                    this.renderColumnHeader(facesContext, uiComponent, thead, facet, element, header);
                }
                this.renderColumnGroup(facesContext, uiComponent, headerFacet, thead, facetClass, element);
                this.renderTableHeader(facesContext, uiComponent, headerFacet, thead, facetClass, element);
            }
            domContext.setCursorParent((Node)root);
        }
    }

    private void renderColumnHeader(FacesContext facesContext, UIComponent uiComponent, Element thead, String facet, String element, boolean header) throws IOException {
        StringTokenizer columnWitdths = this.getColumnWidths(uiComponent);
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        Element tr = domContext.createElement("tr");
        thead.appendChild(tr);
        List childList = this.getRenderedChildColumnsList(uiComponent);
        Iterator childColumns = childList.iterator();
        String width = null;
        int columnIndex = 1;
        int headerStyleLength = this.getHeaderStyles(uiComponent).length;
        int styleIndex = 0;
        while (childColumns.hasNext()) {
            UIComponent nextColumn = (UIComponent)childColumns.next();
            width = columnWitdths != null && columnWitdths.hasMoreTokens() ? columnWitdths.nextToken() : (this.isScrollable(uiComponent) ? "150px" : null);
            if (nextColumn instanceof javax.faces.component.UIColumn) {
                this.processUIColumnHeader(facesContext, uiComponent, (javax.faces.component.UIColumn)nextColumn, tr, domContext, facet, element, width, columnIndex, styleIndex, !childColumns.hasNext());
                ++columnIndex;
            } else if (nextColumn instanceof UIColumns) {
                columnIndex = this.processUIColumnsHeader(facesContext, uiComponent, (UIColumns)nextColumn, tr, domContext, facet, element, width, columnIndex, styleIndex, headerStyleLength);
            }
            if (styleIndex++ != headerStyleLength - 1) continue;
            styleIndex = 0;
        }
        if (header && this.isScrollable(uiComponent)) {
            tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
        }
    }

    private void renderColumnGroup(FacesContext facesContext, UIComponent uiComponent, UIComponent headerFacet, Element thead, String facetClass, String element) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (headerFacet == null || !(headerFacet instanceof ColumnGroup)) {
            return;
        }
        if (!headerFacet.isRendered()) {
            return;
        }
        String sourceClass = "Hdr";
        if (!"th".equals(element)) {
            sourceClass = "Ftr";
        }
        String baseClass = Util.getQualifiedStyleClass(uiComponent, "ColGrp" + sourceClass);
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        Iterator children = headerFacet.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (!(child instanceof HeaderRow) || !child.isRendered()) continue;
            Element tr = domContext.createElement("tr");
            String rowStyleClass = ((HeaderRow)child).getStyleClass();
            rowStyleClass = rowStyleClass == null ? baseClass.replaceAll(sourceClass, sourceClass + "Row") : baseClass.replaceAll(sourceClass, sourceClass + "Row ") + rowStyleClass;
            tr.setAttribute("class", rowStyleClass);
            String rowStyle = ((HeaderRow)child).getStyle();
            if (rowStyle != null) {
                tr.setAttribute("style", rowStyle);
            }
            thead.appendChild(tr);
            Iterator columns = child.getChildren().iterator();
            while (columns.hasNext()) {
                String style;
                String rowspan;
                UIComponent column = (UIComponent)columns.next();
                if (!(column instanceof javax.faces.component.UIColumn)) continue;
                Element th = domContext.createElement(element);
                tr.appendChild(th);
                String styleClass = ((UIColumn)column).getStyleClass();
                styleClass = styleClass == null ? baseClass.replaceAll(sourceClass, sourceClass + "Col") : baseClass.replaceAll(sourceClass, sourceClass + "Col ") + styleClass;
                th.setAttribute("class", styleClass);
                Integer colspan = null;
                try {
                    colspan = Integer.valueOf(((UIColumn)column).getColspan());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (htmlDataTable.isResizable()) {
                    colspan = colspan != null ? new Integer(colspan + colspan) : new Integer(2);
                }
                if (colspan != null) {
                    th.setAttribute("colspan", colspan.toString());
                }
                if ((rowspan = ((UIColumn)column).getRowspan()) != null) {
                    th.setAttribute("rowspan", rowspan);
                }
                if ((style = ((UIColumn)column).getStyle()) != null) {
                    th.setAttribute("style", style);
                }
                domContext.setCursorParent((Node)th);
                TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)column);
            }
        }
    }

    private void renderTableHeader(FacesContext facesContext, UIComponent uiComponent, UIComponent headerFacet, Element thead, String facetClass, String element) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (headerFacet != null && headerFacet.isRendered()) {
            if (headerFacet instanceof ColumnGroup) {
                return;
            }
            this.resetFacetChildId(headerFacet);
            Element tr = domContext.createElement("tr");
            thead.appendChild(tr);
            Element th = domContext.createElement(element);
            tr.appendChild(th);
            if (facetClass != null) {
                th.setAttribute("class", facetClass);
            }
            th.setAttribute("colspan", String.valueOf(this.getNumberOfChildColumns(uiComponent)));
            th.setAttribute("scope", "colgroup");
            domContext.setCursorParent((Node)th);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)th);
            TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)headerFacet);
            if (this.isScrollable(uiComponent)) {
                tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
            }
        }
    }

    private void processUIColumnHeader(FacesContext facesContext, UIComponent uiComponent, javax.faces.component.UIColumn nextColumn, Element tr, DOMContext domContext, String facet, String element, String width, int columnIndex, int styleIndex, boolean lastChild) throws IOException {
        UIComponent nextFacet;
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        Element th = domContext.createElement(element);
        tr.appendChild(th);
        Element cursorParent = th;
        if (htmlDataTable.isResizable()) {
            if (!lastChild) {
                Element handlerTd = domContext.createElement(element);
                handlerTd.setAttribute("valign", "top");
                handlerTd.setAttribute("class", "iceDatTblResBor");
                handlerTd.setAttribute("onmouseover", "ResizableUtil.adjustHeight(this)");
                Element resizeHandler = domContext.createElement("div");
                resizeHandler.setAttribute("style", "cursor: e-resize; display:block;  height:100%;");
                resizeHandler.setAttribute("onmousedown", "new Ice.ResizableGrid(event);");
                resizeHandler.setAttribute("class", "iceDatTblResHdlr");
                resizeHandler.appendChild(domContext.createTextNode("&nbsp;"));
                handlerTd.appendChild(resizeHandler);
                tr.appendChild(handlerTd);
            }
            Element columnHeaderDiv = domContext.createElement("div");
            th.appendChild(columnHeaderDiv);
            cursorParent = columnHeaderDiv;
        }
        if ("header".equalsIgnoreCase(facet)) {
            th.setAttribute("class", this.getHeaderStyles(uiComponent)[styleIndex]);
        } else {
            th.setAttribute("class", this.getFooterClass((UIComponent)htmlDataTable));
        }
        if (width != null) {
            th.setAttribute("style", "width:" + width + ";overflow:hidden;");
        }
        if ((nextFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, (String)facet)) != null) {
            this.resetFacetChildId(nextFacet);
            domContext.setCursorParent((Node)cursorParent);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)cursorParent);
            TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextFacet);
        }
    }

    private int processUIColumnsHeader(FacesContext facesContext, UIComponent uiComponent, UIColumns nextColumn, Element tr, DOMContext domContext, String facet, String element, String width, int columnIndex, int styleIndex, int headerStyleLength) throws IOException {
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        int rowIndex = nextColumn.getFirst();
        nextColumn.encodeBegin(facesContext);
        nextColumn.setRowIndex(rowIndex);
        while (nextColumn.isRowAvailable()) {
            UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, (String)facet);
            if (headerFacet != null) {
                Node oldParent = domContext.getCursorParent();
                Element th = domContext.createElement(element);
                tr.appendChild(th);
                th.setAttribute("class", this.getHeaderStyles(uiComponent)[styleIndex]);
                if (width != null) {
                    th.setAttribute("style", "width:" + width + ";");
                }
                domContext.setCursorParent((Node)th);
                domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)th);
                TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)headerFacet);
                domContext.setCursorParent(oldParent);
            }
            if (styleIndex++ == headerStyleLength - 1) {
                styleIndex = 0;
            }
            ++columnIndex;
            nextColumn.setRowIndex(++rowIndex);
        }
        nextColumn.setRowIndex(-1);
        return columnIndex;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        Element root = (Element)domContext.getRootNode();
        if (this.isScrollable(uiComponent)) {
            root = this.getScrollableBodyTableElement(root);
        }
        DOMContext.removeChildrenByTagName((Element)root, (String)"tbody");
        Element tBody = domContext.createElement("tbody");
        root.appendChild(tBody);
        HtmlDataTable uiData = (HtmlDataTable)uiComponent;
        int rowIndex = uiData.getFirst();
        if (uiData.getRowCount() == 0) {
            Element tr = domContext.createElement("tr");
            tBody.appendChild(tr);
            Element td = domContext.createElement("td");
            tr.appendChild(td);
            domContext.stepOver();
            return;
        }
        if (uiData.getRowCount() >= 0 && uiData.getRowCount() <= rowIndex) {
            domContext.stepOver();
            return;
        }
        uiData.setRowIndex(rowIndex);
        int numberOfRowsToDisplay = uiData.getRows();
        int countOfRowsDisplayed = 0;
        String[] rowStyles = this.getRowStyles(uiComponent);
        int rowStyleIndex = 0;
        int rowStylesMaxIndex = rowStyles.length - 1;
        RowSelector rowSelector = TableRenderer.getRowSelector(uiComponent);
        boolean rowSelectorFound = rowSelector != null;
        boolean toggleOnClick = false;
        String rowSelectionFunctionName = null;
        String rowSelectionUseEvent = "false";
        boolean rowSelectorCodeAdded = false;
        Node scriptNode = null;
        Element hiddenInputNode = null;
        UIComponent form = DomBasicRenderer.findForm((UIComponent)uiComponent);
        String formId = form == null ? "" : form.getClientId(facesContext);
        String paramId = TableRenderer.getSelectedRowParameterName(uiComponent.getClientId(facesContext));
        if (rowSelectorFound) {
            toggleOnClick = rowSelector.getToggleOnClick();
            Element rowSelectedField = domContext.createElement("input");
            boolean toggleOnInput = rowSelector.getToggleOnInput();
            rowSelectionUseEvent = toggleOnInput ? "false" : "true";
            rowSelectedField.setAttribute("name", paramId);
            rowSelectedField.setAttribute("type", "hidden");
            hiddenInputNode = rowSelectedField;
            rowSelectionFunctionName = "Ice.tableRowClicked";
        }
        String[] columnStyles = this.getColumnStyleClasses(uiComponent);
        int columnStylesMaxIndex = columnStyles.length - 1;
        this.resetGroupState((UIComponent)uiData);
        while (uiData.isRowAvailable()) {
            int columnStyleIndex = 0;
            String selectedClass = null;
            if (rowStylesMaxIndex >= 0) {
                selectedClass = rowStyles[rowStyleIndex];
            }
            Iterator childs = uiData.getChildren().iterator();
            Element tr = domContext.createElement("tr");
            if (rowSelectorFound && toggleOnClick) {
                tr.setAttribute("onclick", rowSelectionFunctionName + "(event, " + rowSelectionUseEvent + ",'" + uiData.getRowIndex() + "', '" + formId + "', '" + paramId + "');");
            }
            String id = uiComponent.getClientId(facesContext);
            tr.setAttribute("id", id);
            if (rowSelectorFound) {
                if (Boolean.TRUE.equals(rowSelector.getValue())) {
                    selectedClass = selectedClass + " " + rowSelector.getSelectedClass();
                    tr.setAttribute("onmouseover", "this.className='" + CoreUtils.getPortletStyleClass((String)"portlet-section-body-hover") + " " + rowSelector.getSelectedMouseOverClass() + "'");
                } else {
                    selectedClass = selectedClass + " " + rowSelector.getStyleClass();
                    tr.setAttribute("onmouseover", "this.className='" + CoreUtils.getPortletStyleClass((String)"portlet-section-body-hover") + " " + rowSelector.getMouseOverClass() + "'");
                }
                tr.setAttribute("onmouseout", "this.className='" + this.getPortletAlternateRowClass(selectedClass, rowIndex) + "'");
            }
            domContext.setCursorParent((Node)tBody);
            tBody.appendChild(tr);
            selectedClass = this.getPortletAlternateRowClass(selectedClass, rowIndex);
            tr.setAttribute("class", selectedClass);
            if (rowStylesMaxIndex >= 0 && ++rowStyleIndex > rowStylesMaxIndex) {
                rowStyleIndex = 0;
            }
            int colNumber = 1;
            StringTokenizer columnWitdths = this.getColumnWidths((UIComponent)uiData);
            while (childs.hasNext()) {
                UIComponent nextChild = (UIComponent)childs.next();
                if (!nextChild.isRendered()) continue;
                if (nextChild instanceof javax.faces.component.UIColumn) {
                    Element td = domContext.createElement("td");
                    String iceColumnStyle = null;
                    String iceColumnStyleClass = null;
                    if (nextChild instanceof UIColumn) {
                        UIColumn iceColumn = (UIColumn)nextChild;
                        iceColumnStyle = iceColumn.getStyle();
                        iceColumnStyleClass = iceColumn.getStyleClass();
                        if (iceColumn.getGroupOn() != null) {
                            if (iceColumn.groupFound()) {
                                Element groupedTd = iceColumn.getGroupedTd();
                                groupedTd.setAttribute("rowspan", String.valueOf(iceColumn.getGroupCount()));
                                continue;
                            }
                            iceColumn.setGroupedTd(td);
                        }
                    }
                    if (!rowSelectorCodeAdded && scriptNode != null) {
                        td.appendChild(scriptNode);
                    }
                    if (null != hiddenInputNode) {
                        td.appendChild(hiddenInputNode);
                    }
                    this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, colNumber++, uiComponent);
                    if (this.isScrollable(uiComponent)) {
                        String width = "150px";
                        if (columnWitdths != null && columnWitdths.hasMoreTokens()) {
                            width = columnWitdths.nextToken();
                        }
                        td.setAttribute("style", "width:" + width + ";overflow:hidden;");
                    }
                    if (iceColumnStyle != null) {
                        String existingStyle = td.getAttribute("style");
                        if (existingStyle != null) {
                            td.setAttribute("style", existingStyle + ";" + iceColumnStyle);
                        } else {
                            td.setAttribute("style", iceColumnStyle);
                        }
                    }
                    if (iceColumnStyleClass != null) {
                        String existingStyleClass = td.getAttribute("class");
                        if (existingStyleClass != null) {
                            td.setAttribute("class", existingStyleClass + " " + iceColumnStyleClass);
                        } else {
                            td.setAttribute("class", iceColumnStyleClass);
                        }
                    }
                    tr.appendChild(td);
                    if (uiData.isResizable() && childs.hasNext()) {
                        Element eTd = domContext.createElement("td");
                        eTd.setAttribute("class", "iceDatTblBlkTd");
                        Element img = domContext.createElement("img");
                        img.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)FacesContext.getCurrentInstance(), (String)"./xmlhttp/css/xp/css-images/spacer.gif"));
                        eTd.appendChild(img);
                        tr.appendChild(eTd);
                    }
                    if (++columnStyleIndex > columnStylesMaxIndex) {
                        columnStyleIndex = 0;
                    }
                    Node oldCursorParent = domContext.getCursorParent();
                    domContext.setCursorParent((Node)td);
                    domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
                    TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextChild);
                    domContext.setCursorParent(oldCursorParent);
                    continue;
                }
                if (!(nextChild instanceof UIColumns)) continue;
                String width = null;
                if (this.isScrollable(uiComponent) && columnWitdths != null && columnWitdths.hasMoreTokens()) {
                    width = columnWitdths.nextToken();
                }
                nextChild.encodeBegin(facesContext);
                this.encodeColumns(facesContext, nextChild, domContext, tr, columnStyles, columnStylesMaxIndex, columnStyleIndex, colNumber, width, hiddenInputNode);
                nextChild.encodeEnd(facesContext);
                colNumber = uiData.getColNumber();
            }
            if (numberOfRowsToDisplay > 0 && ++countOfRowsDisplayed >= numberOfRowsToDisplay || uiData.getRowCount() >= 0 && ++rowIndex >= uiData.getRowCount()) break;
            uiData.setRowIndex(rowIndex);
        }
        uiData.setRowIndex(-1);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void encodeColumns(FacesContext facesContext, UIComponent columns, DOMContext domContext, Node tr, String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, int colNumber, String width, Element rowSelectorHiddenField) throws IOException {
        UIColumns uiList = (UIColumns)columns;
        int rowIndex = uiList.getFirst();
        uiList.setRowIndex(rowIndex);
        int numberOfRowsToDisplay = uiList.getRows();
        domContext.setCursorParent(tr);
        Node oldCursorParent = domContext.getCursorParent();
        for (int countOfRowsDisplayed = 0; uiList.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay); ++countOfRowsDisplayed) {
            Iterator childs = columns.getChildren().iterator();
            Element td = domContext.createElement("td");
            if (null != rowSelectorHiddenField) {
                td.appendChild(rowSelectorHiddenField);
            }
            if (width != null) {
                td.setAttribute("style", "width:" + width + ";overflow:hidden;");
            }
            domContext.setCursorParent(oldCursorParent);
            tr.appendChild(td);
            while (childs.hasNext()) {
                UIComponent nextChild = (UIComponent)childs.next();
                if (!nextChild.isRendered()) continue;
                domContext.setCursorParent((Node)td);
                this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, colNumber++, columns.getParent());
                if (++columnStyleIndex > columnStylesMaxIndex) {
                    columnStyleIndex = 0;
                }
                TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextChild);
                domContext.setCursorParent(oldCursorParent);
            }
            uiList.setRowIndex(++rowIndex);
        }
        ((HtmlDataTable)uiList.getParent()).setColNumber(colNumber);
        uiList.setRowIndex(-1);
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if ((!(kid instanceof javax.faces.component.UIColumn) || !kid.isRendered()) && !(kid instanceof UIColumns)) continue;
            results.add(kid);
        }
        return results;
    }

    protected boolean childColumnHasFacetWithName(UIComponent component, String facetName) {
        Iterator childColumns = this.getRenderedChildColumnsIterator(component);
        while (childColumns.hasNext()) {
            UIComponent nextChildColumn = (UIComponent)childColumns.next();
            if (TableRenderer.getFacetByName((UIComponent)nextChildColumn, (String)facetName) == null) continue;
            return true;
        }
        return false;
    }

    public static String getSelectedRowParameterName(String dataTableId) {
        int i = dataTableId.lastIndexOf(":");
        dataTableId = dataTableId.substring(0, i);
        return dataTableId + SELECTED_ROWS;
    }

    public static RowSelector getRowSelector(UIComponent comp) {
        if (comp instanceof RowSelector) {
            return (RowSelector)comp;
        }
        Iterator iter = comp.getChildren().iterator();
        while (iter.hasNext()) {
            RowSelector rs;
            UIComponent kid = (UIComponent)iter.next();
            if (kid instanceof HtmlDataTable || (rs = TableRenderer.getRowSelector(kid)) == null) continue;
            if (!rs.isRendered()) {
                return null;
            }
            return rs;
        }
        return null;
    }

    private int rowSelectorNumber(FacesContext context) {
        Map m = context.getExternalContext().getRequestMap();
        String key = RowSelector.class.getName() + "-Selector";
        Integer I = (Integer)m.get(key);
        int i = 0;
        if (I != null) {
            i = I;
            ++i;
        }
        I = new Integer(i);
        m.put(key, I);
        return i;
    }

    protected int getNumberOfChildColumns(UIComponent component) {
        int size = this.getRenderedChildColumnsList(component).size();
        Iterator it = this.getRenderedChildColumnsList(component).iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!(uiComponent instanceof UIColumns)) continue;
            size += ((UIColumns)uiComponent).getRowCount();
        }
        return size;
    }

    protected String[] getColumnStyleClasses(UIComponent uiComponent) {
        String[] columnStyles = super.getColumnStyleClasses(uiComponent);
        if (columnStyles.length == 0) {
            columnStyles = new String[]{Util.getQualifiedStyleClass(uiComponent, "Col1"), Util.getQualifiedStyleClass(uiComponent, "Col2")};
        } else {
            for (int i = 0; i < columnStyles.length; ++i) {
                columnStyles[i] = Util.getQualifiedStyleClass(uiComponent, columnStyles[i], "Col", "columnClasses");
            }
        }
        return columnStyles;
    }

    public String[] getRowStyleClasses(UIComponent uiComponent) {
        String[] rowClasses = super.getRowStyleClasses(uiComponent);
        for (int i = 0; i < rowClasses.length; ++i) {
            rowClasses[i] = Util.getQualifiedStyleClass(uiComponent, rowClasses[i], "Row", "rowClasses");
        }
        return rowClasses;
    }

    public String[] getHeaderStyleClasses(UIComponent uiComponent) {
        String headerClass = this.getHeaderClass(uiComponent).replaceAll("iceDatTblHdr", "");
        String[] headerClasses = this.getStyleClasses(uiComponent, "headerClasses");
        for (int i = 0; i < headerClasses.length; ++i) {
            headerClasses[i] = Util.getQualifiedStyleClass(uiComponent, headerClasses[i], "ColHdr", "headerClasses") + (headerClass.length() > 0 ? headerClass : "");
        }
        return headerClasses;
    }

    String getPortletAlternateRowClass(String selectedClass, int rowIndex) {
        String rowClass = "portlet-section-alternate";
        if (rowIndex % 2 == 0) {
            rowClass = "portlet-section-body";
        }
        if (selectedClass.indexOf(32) > 1) {
            return selectedClass.replaceFirst(" ", " " + CoreUtils.getPortletStyleClass((String)(rowClass + " ")));
        }
        selectedClass = selectedClass + CoreUtils.getPortletStyleClass((String)("" + rowClass));
        return selectedClass;
    }

    void resetGroupState(UIComponent uiComponent) {
        Iterator childs = uiComponent.getChildren().iterator();
        while (childs.hasNext()) {
            UIComponent child = (UIComponent)childs.next();
            if (!(child instanceof UIColumn)) continue;
            ((UIColumn)child).resetGroupState();
        }
    }
}

