/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.renderkit;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.dragdrop.DndEvent;
import com.icesoft.faces.component.dragdrop.DragEvent;
import com.icesoft.faces.component.dragdrop.DropEvent;
import com.icesoft.faces.component.ext.HtmlPanelGroup;
import com.icesoft.faces.component.menupopup.MenuPopupHelper;
import com.icesoft.faces.component.panelpopup.PanelPopup;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.context.effects.DragDrop;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.utils.DnDCache;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GroupRenderer
extends com.icesoft.faces.renderkit.dom_html_basic.GroupRenderer {
    protected static final String STATUS = "status";
    protected static final String DROP = "dropID";
    private static Log log = LogFactory.getLog((Class)GroupRenderer.class);
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU_JS_EVENTS = LocalEffectEncoder.maskEvents((String[])ExtendedAttributeConstants.getAttributes(32));
    private static final String[] passThruAttributes = ExtendedAttributeConstants.getAttributes(32, new String[][]{PASSTHRU_EXCLUDE, PASSTHRU_JS_EVENTS});

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        try {
            Element rootSpan;
            String viewID = facesContext.getViewRoot().getViewId();
            String style = ((HtmlPanelGroup)uiComponent).getStyle();
            String styleClass = ((HtmlPanelGroup)uiComponent).getStyleClass();
            String blockingFlag = (String)facesContext.getExternalContext().getRequestMap().get("BlockingServlet");
            String dndType = this.getDndType(uiComponent);
            DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
            if (!domContext.isInitialized()) {
                rootSpan = domContext.createElement("div");
                domContext.setRootNode((Node)rootSpan);
                GroupRenderer.setRootElementId((FacesContext)facesContext, (Element)rootSpan, (UIComponent)uiComponent);
                if (dndType != null) {
                    Element statusField = this.createHiddenField(domContext, facesContext, uiComponent, STATUS);
                    rootSpan.appendChild(statusField);
                    Element targetID = this.createHiddenField(domContext, facesContext, uiComponent, DROP);
                    rootSpan.appendChild(targetID);
                }
            }
            rootSpan = (Element)domContext.getRootNode();
            if (dndType != null) {
                DnDCache.getInstance(facesContext, true).put(uiComponent.getClientId(facesContext), (HtmlPanelGroup)uiComponent, facesContext);
                String call = this.addJavascriptCalls(uiComponent, dndType, null, facesContext);
                HashMap<String, String> rendererJavascriptDraggable = new HashMap<String, String>();
                rendererJavascriptDraggable.put("onmouseout", "Draggable.removeMe(this.id);");
                rendererJavascriptDraggable.put("onmousemove", call);
                LocalEffectEncoder.encode((FacesContext)facesContext, (UIComponent)uiComponent, (String[])PASSTHRU_JS_EVENTS, rendererJavascriptDraggable, (Element)rootSpan, null);
            } else {
                LocalEffectEncoder.encode((FacesContext)facesContext, (UIComponent)uiComponent, (String[])PASSTHRU_JS_EVENTS, null, (Element)rootSpan, null);
            }
            if (styleClass != null) {
                rootSpan.setAttribute("class", styleClass);
            }
            JavascriptContext.fireEffect((UIComponent)uiComponent, (FacesContext)facesContext);
            String extraStyle = null;
            String scrollWidth = (String)uiComponent.getAttributes().get("scrollWidth");
            String scrollHeight = (String)uiComponent.getAttributes().get("scrollHeight");
            if (scrollHeight != null || scrollWidth != null) {
                if (extraStyle == null) {
                    extraStyle = "";
                }
                extraStyle = scrollHeight == null ? extraStyle + "width:" + scrollWidth + ";overflow:auto;" : (scrollWidth == null ? extraStyle + "height:" + scrollHeight + ";overflow:auto;" : extraStyle + "width:" + scrollWidth + ";height:" + scrollHeight + ";overflow:auto;");
            }
            CurrentStyle.apply((FacesContext)facesContext, (UIComponent)uiComponent, null, (String)extraStyle);
            MenuPopupHelper.renderMenuPopupHandler(facesContext, uiComponent, rootSpan);
            PassThruAttributeRenderer.renderNonBooleanHtmlAttributes((UIComponent)uiComponent, (Element)rootSpan, (String[])passThruAttributes);
            domContext.stepInto(uiComponent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String addJavascriptCalls(UIComponent uiComponent, String dndType, String handleId, FacesContext facesContext) {
        String calls = "";
        boolean dragListener = uiComponent.getAttributes().get("dragListener") != null;
        boolean dropListener = uiComponent.getAttributes().get("dropListener") != null;
        String dragMask = DndEvent.parseMask((String)uiComponent.getAttributes().get("dragMask"));
        String dropMask = DndEvent.parseMask((String)uiComponent.getAttributes().get("dropMask"));
        String dragOptions = (String)uiComponent.getAttributes().get("dragOptions");
        String hoverClass = (String)uiComponent.getAttributes().get("hoverclass");
        if (!dragListener && dragMask == null) {
            dragMask = "1,4,5";
        }
        if (!dropListener) {
            dropMask = "1,2,3,4,5";
        }
        if ("DRAG".equalsIgnoreCase(dndType)) {
            calls = calls + DragDrop.addDragable((String)uiComponent.getClientId(facesContext), (String)handleId, (String)dragOptions, (String)dragMask, (FacesContext)facesContext);
        } else if ("drop".equalsIgnoreCase(dndType)) {
            DragDrop.addDroptarget((String)uiComponent.getClientId(facesContext), null, (FacesContext)facesContext, (String)dropMask, (String)hoverClass);
        } else if ("dragdrop".equalsIgnoreCase(dndType)) {
            calls = calls + DragDrop.addDragable((String)uiComponent.getClientId(facesContext), (String)handleId, (String)dragOptions, (String)dragMask, (FacesContext)facesContext);
            DragDrop.addDroptarget((String)uiComponent.getClientId(facesContext), null, (FacesContext)facesContext, (String)dropMask, (String)hoverClass);
        } else {
            throw new IllegalArgumentException("Value [" + dndType + "] is not valid for dndType. Please use drag or drop");
        }
        return calls;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        CoreUtils.addPanelTooltip((FacesContext)facesContext, (UIComponent)uiComponent);
        domContext.stepOver();
    }

    protected String appendStyle(String currentStyle, String additionalStyle) {
        String result = "";
        if (!GroupRenderer.isBlank(currentStyle)) {
            result = currentStyle;
        }
        if (!GroupRenderer.isBlank(additionalStyle)) {
            result = result + additionalStyle;
        }
        if (GroupRenderer.isBlank(result)) {
            return null;
        }
        return result;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public void decode(FacesContext context, UIComponent component) {
        PanelPopup panel;
        String dndType;
        super.decode(context, component);
        if (log.isTraceEnabled()) {
            log.trace((Object)"GroupRenderer:decode");
        }
        MenuPopupHelper.decodeMenuContext(context, component);
        if (component instanceof PanelPopup && ("dragdrop".equals(dndType = this.getDndType(component)) || "DRAG".equals(dndType)) && ((panel = (PanelPopup)component).getAutoPosition() != null || panel.isAutoCentre())) {
            panel.setDragged(true);
        }
        if (component instanceof HtmlPanelGroup) {
            HtmlPanelGroup panel2 = (HtmlPanelGroup)component;
            String dndType2 = this.getDndType(component);
            if (panel2.getDraggable() != null || panel2.getDropTarget() != null) {
                DndEvent event;
                int type;
                Object targetDropValue;
                Object targetDragValue;
                String targetID;
                block15: {
                    String fieldName;
                    Map requestMap = context.getExternalContext().getRequestParameterValuesMap();
                    String status = this.getParamamterValue((String[])requestMap.get(fieldName = this.getHiddenFieldName(context, component, STATUS)));
                    if (status == null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Drag Drop Status for ID [" + panel2.getClientId(context) + "] Field Name [" + fieldName + "] is null. Returning"));
                        }
                        return;
                    }
                    targetID = this.getParamamterValue((String[])requestMap.get(this.getHiddenFieldName(context, component, DROP)));
                    targetDragValue = null;
                    targetDropValue = null;
                    if (targetID != null && targetID.length() > 0) {
                        DnDCache dndCache = DnDCache.getInstance(context, false);
                        if ("drop".equals(dndType2)) {
                            targetDragValue = dndCache.getDragValue(targetID);
                            targetDropValue = dndCache.getDropValue(panel2.getClientId(context));
                        } else {
                            targetDragValue = dndCache.getDragValue(panel2.getClientId(context));
                            targetDropValue = dndCache.getDropValue(targetID);
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Dnd Event Client ID [" + component.getClientId(context) + "] Target ID [" + targetID + "] Status [" + status + "]"));
                    }
                    if (panel2.getDragListener() == null && panel2.getDropListener() == null) {
                        return;
                    }
                    type = 0;
                    try {
                        type = Integer.parseInt(status);
                    }
                    catch (NumberFormatException e) {
                        if (status == null && status.length() == 0) break block15;
                        return;
                    }
                }
                MethodBinding listener = panel2.getDragListener();
                if (listener != null) {
                    event = new DragEvent(component, type, targetID, targetDragValue, targetDropValue);
                    panel2.queueEvent(event);
                }
                if ((listener = panel2.getDropListener()) != null) {
                    event = new DropEvent(component, type, targetID, targetDragValue, targetDropValue);
                    panel2.queueEvent(event);
                }
            }
        }
    }

    protected Element createHiddenField(DOMContext domContext, FacesContext facesContext, UIComponent uiComponent, String name) {
        Element ele = domContext.createElement("input");
        ele.setAttribute("type", "hidden");
        String n = ClientIdPool.get((String)this.getHiddenFieldName(facesContext, uiComponent, name));
        ele.setAttribute("name", n);
        ele.setAttribute("id", n);
        ele.setAttribute("value", "");
        return ele;
    }

    protected String getHiddenFieldName(FacesContext facesContext, UIComponent uiComponent, String name) {
        UIComponent form = GroupRenderer.findForm((UIComponent)uiComponent);
        String formId = form.getClientId(facesContext);
        String clientId = uiComponent.getClientId(facesContext);
        return formId + ':' + "_id" + clientId + name;
    }

    protected String getDndType(UIComponent uiComponent) {
        String dndType = null;
        String draggable = (String)uiComponent.getAttributes().get("draggable");
        String droppable = (String)uiComponent.getAttributes().get("dropTarget");
        if ("true".equalsIgnoreCase(draggable) && "true".equalsIgnoreCase(droppable)) {
            dndType = "dragdrop";
        } else if ("true".equalsIgnoreCase(draggable)) {
            dndType = "DRAG";
        } else if ("true".equalsIgnoreCase(droppable)) {
            dndType = "drop";
        }
        return dndType;
    }

    private String getParamamterValue(String[] sa) {
        if (sa == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Null parameter value");
            }
            return null;
        }
        String result = null;
        for (int i = 0; i < sa.length; ++i) {
            String s = sa[i];
            if (log.isTraceEnabled()) {
                log.trace((Object)("getParameterValue Checking [" + s + "]"));
            }
            if (s == null || s.trim().length() <= 0) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("getParameterValue result:" + s));
            }
            result = s;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Length [" + sa.length + "] Result [" + result + "]"));
        }
        return result;
    }
}

