/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputtext;

import com.icesoft.faces.component.selectinputtext.SelectInputText;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.DOMUtils;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SelectInputTextRenderer
extends DomBasicInputRenderer {
    private static final String AUTOCOMPLETE_DIV = "_div";
    static final String AUTOCOMPLETE_INDEX = "_idx";
    private static final Log log = LogFactory.getLog((Class)SelectInputTextRenderer.class);
    private static final String[] passThruAttributes = new String[]{"accesskey", "alt", "dir", "lang", "maxlength", "onchange", "onclick", "ondblclick", "onkeypress", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect", "rows", "size", "style", "tabindex", "title", "width"};

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        if (log.isTraceEnabled()) {
            log.trace((Object)"encodeBegin");
        }
        SelectInputText component = (SelectInputText)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        String divId = ClientIdPool.get((String)(clientId + AUTOCOMPLETE_DIV));
        String call = " new Ice.Autocompleter('" + clientId + "','" + divId + "', " + component.getOptions() + " ,'" + component.getRowClass() + "','" + component.getSelectedRowClass() + "');";
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            Element input = domContext.createElement("input");
            input.setAttribute("type", "text");
            SelectInputTextRenderer.setRootElementId((FacesContext)facesContext, (Element)input, (UIComponent)uiComponent);
            root.appendChild(input);
            input.setAttribute("name", clientId);
            input.setAttribute("class", component.getInputTextClass());
            String mousedownScript = (String)uiComponent.getAttributes().get("onmousedown");
            input.setAttribute("onmousedown", SelectInputTextRenderer.combinedPassThru((String)mousedownScript, (String)"this.focus();"));
            String inputStyle = component.getWidthAsStyle();
            if (inputStyle != null && inputStyle.length() > 0) {
                input.setAttribute("style", inputStyle);
            } else {
                input.removeAttribute("style");
            }
            input.setAttribute("autocomplete", "off");
            Element div = domContext.createElement("div");
            String listClass = component.getListClass();
            div.setAttribute("id", divId);
            if (listClass == null) {
                div.setAttribute("style", "display:none;border:1px solid black;background-color:white;z-index:500;");
            } else {
                div.setAttribute("class", listClass);
            }
            root.appendChild(div);
            Element index = domContext.createElement("input");
            index.setAttribute("type", "hidden");
            String indexId = ClientIdPool.get((String)(clientId + AUTOCOMPLETE_INDEX));
            index.setAttribute("name", indexId);
            root.appendChild(index);
            String rootStyle = component.getStyle();
            if (rootStyle != null && rootStyle.length() > 0) {
                root.setAttribute("style", rootStyle);
            } else {
                root.removeAttribute("style");
            }
            root.setAttribute("class", component.getStyleClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("SelectInputText:encodeBegin():component created with the following id : " + clientId));
            }
            PassThruAttributeRenderer.renderHtmlAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (String[])passThruAttributes);
            PassThruAttributeRenderer.renderBooleanAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (Element)input, (String[])PassThruAttributeRenderer.EMPTY_STRING_ARRAY);
        }
        if (!component.isDisabled() && !component.isReadonly()) {
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        SelectInputText component = (SelectInputText)uiComponent;
        Element input = (Element)domContext.getRootNode().getFirstChild();
        input.setAttribute("onfocus", "setFocus(this.id);");
        input.setAttribute("onblur", "setFocus('');");
        String value = this.getValue(facesContext, uiComponent);
        if (value != null) {
            input.setAttribute("value", value);
            if (component.hasChanged()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SelectInputText:encodeChildren(): component's value have been changed, start populating list : ");
                }
                this.populateList(facesContext, component);
                component.setChangedComponentId(null);
            }
        }
        domContext.stepOver();
    }

    public void populateList(FacesContext facesContext, SelectInputText component) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"populateList");
        }
        component.populateItemList();
        Iterator matchs = component.getItemList();
        int rows = component.getRows();
        int rowCounter = 0;
        if (component.getSelectFacet() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SelectInputText:populateList(): \"selectInputText\" facet found, generate generic html for list");
            }
            UIComponent facet = component.getSelectFacet();
            DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)component);
            Element listDiv = domContext.createElement("div");
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            component.setIndex(0);
            while (matchs.hasNext() && (rowCounter++ < rows || rows == 0)) {
                Element div = domContext.createElement("div");
                SelectItem item = (SelectItem)matchs.next();
                requestMap.put(component.getListVar(), item.getValue());
                listDiv.appendChild(div);
                Element spanToDisplay = domContext.createElement("span");
                spanToDisplay.setAttribute("class", "informal");
                div.appendChild(spanToDisplay);
                domContext.setCursorParent((Node)spanToDisplay);
                SelectInputTextRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)facet);
                Element spanToSelect = domContext.createElement("span");
                spanToSelect.setAttribute("style", "visibility:hidden;display:none;");
                String itemLabel = item.getLabel();
                if (itemLabel == null) {
                    itemLabel = SelectInputTextRenderer.converterGetAsString((FacesContext)facesContext, (UIComponent)component, (Object)item.getValue());
                }
                Text label = domContext.createTextNode(DOMUtils.escapeAnsi((String)itemLabel));
                spanToSelect.appendChild(label);
                div.appendChild(spanToSelect);
                component.resetId(facet);
            }
            component.setIndex(-1);
            String nodeValue = DOMUtils.nodeToString((Node)listDiv).replaceAll("\n", "");
            String call = "Autocompleter.Finder.find('" + component.getClientId(facesContext) + "').updateNOW('" + nodeValue + "');";
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SelectInputText:populateList(): \"selectItem(s)\" found, generate plain-text for list");
            }
            if (matchs.hasNext()) {
                StringBuffer sb = new StringBuffer("<div>");
                SelectItem item = null;
                while (matchs.hasNext() && (rowCounter++ < rows || rows == 0)) {
                    item = (SelectItem)matchs.next();
                    String itemLabel = item.getLabel();
                    if (itemLabel == null) {
                        itemLabel = SelectInputTextRenderer.converterGetAsString((FacesContext)facesContext, (UIComponent)component, (Object)item.getValue());
                    }
                    sb.append("<div>").append(DOMUtils.escapeAnsi((String)itemLabel)).append("</div>");
                }
                sb.append("</div>");
                String call = "Autocompleter.Finder.find('" + component.getClientId(facesContext) + "').updateNOW('" + sb.toString() + "');";
                JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
            }
        }
    }
}

