/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.augmentedreality;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.augmentedreality.AugmentedReality;
import org.icefaces.mobi.component.augmentedreality.AugmentedRealityLocations;
import org.icefaces.mobi.component.augmentedreality.AugmentedRealityMarkers;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.util.MobiJSFUtils;

public class AugmentedRealityRenderer
extends BaseInputRenderer {
    private static final String LOC_LABEL = "locationLabel";
    private static final String LOC_LAT = "locationLat";
    private static final String LOC_LON = "locationLon";
    private static final String LOC_ALT = "locationAlt";
    private static final String LOC_DIR = "locationDir";
    private static final String LOC_ICON = "locationIcon";
    private static final String MARK_MODEL = "markerModel";
    private static final String MARK_LABEL = "markerLabel";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String style;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        AugmentedReality ag = (AugmentedReality)uiComponent;
        writer.startElement("button", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        String buttonValue = ag.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)ag)) {
            buttonValue = ag.getCaptureMessageLabel();
        }
        if (null != ag.getStyle() && (style = ag.getStyle()).trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        StringBuilder defaultClass = new StringBuilder("mobi-button ui-btn-up-c");
        if (null != ag.getStyleClass()) {
            String styleClass = ag.getStyleClass();
            defaultClass.append(" ").append(styleClass);
        }
        writer.writeAttribute("class", (Object)defaultClass, "class");
        String locationsString = "";
        for (UIComponent child : ag.getChildren()) {
            if (child instanceof AugmentedRealityLocations) {
                AugmentedRealityLocations locations = (AugmentedRealityLocations)child;
                locationsString = this.iterateLocations(facesContext, locations, ag.getUrlBase());
            }
            if (!(child instanceof AugmentedRealityMarkers)) continue;
            AugmentedRealityMarkers markers = (AugmentedRealityMarkers)child;
            locationsString = locationsString + this.iterateMarkers(facesContext, markers);
            locationsString = locationsString + "'v':'vuforia'";
        }
        String script = "bridgeit.augmentedReality( '" + clientId + "', '', {postURL:'" + MobiJSFUtils.getPostURL() + "'," + "cookies:{'JSESSIONID':'" + MobiJSFUtils.getSessionIdCookie(facesContext) + "'}," + " locations:{" + locationsString + "}});";
        writer.writeAttribute("onclick", (Object)script, null);
        writer.startElement("span", uiComponent);
        writer.writeText((Object)buttonValue, null);
        writer.endElement("span");
        writer.endElement("button");
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        String submittedString;
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        AugmentedReality aug = (AugmentedReality)component;
        String clientId = component.getClientId();
        Object submitted = parameterMap.get(clientId);
        if (null == submitted) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            submitted = auxMap.get(clientId);
        }
        if (null != submitted && (submittedString = String.valueOf(submitted)) != null) {
            Object convertedValue = this.getConvertedValue(facesContext, component, submittedString);
            this.setSubmittedValue((UIComponent)aug, convertedValue);
        }
    }

    String iterateLocations(FacesContext facesContext, AugmentedRealityLocations locations, String urlBase) {
        String var = locations.getVar();
        if (null == var) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Collection items = (Collection)locations.getValue();
        for (Object item : items) {
            Object oldVar = requestMap.put(var, item);
            Map attrs = locations.getAttributes();
            String itemLabel = (String)attrs.get(LOC_LABEL);
            result.append("'");
            result.append(itemLabel);
            result.append("'");
            result.append(":");
            result.append("'");
            result.append(attrs.get(LOC_LAT)).append(",");
            result.append(attrs.get(LOC_LON)).append(",");
            Object itemAlt = attrs.get(LOC_ALT);
            if (null != itemAlt) {
                result.append(itemAlt);
            }
            result.append(",");
            Object itemDir = attrs.get(LOC_DIR);
            if (null != itemDir) {
                result.append(itemDir);
            }
            result.append(",");
            String itemIcon = (String)attrs.get(LOC_ICON);
            if (null != itemIcon) {
                result.append(itemIcon);
            }
            result.append("'");
            result.append(",");
            requestMap.put(var, oldVar);
        }
        String finalResult = result.toString();
        return finalResult.length() > 0 ? finalResult.substring(0, finalResult.length() - 1) : "";
    }

    String iterateMarkers(FacesContext facesContext, AugmentedRealityMarkers markers) {
        String var = markers.getVar();
        if (null == var) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Collection items = (Collection)markers.getValue();
        int index = 0;
        for (Object item : items) {
            Object oldVar = requestMap.put(var, item);
            Map attrs = markers.getAttributes();
            String markerLabel = (String)attrs.get(MARK_LABEL);
            String itemID = "_" + index;
            result.append("'");
            result.append(markerLabel + itemID);
            result.append("'");
            result.append(":");
            String markerModel = (String)attrs.get(MARK_MODEL);
            if (null != markerModel) {
                result.append("'");
                result.append(markerModel);
                result.append("'");
            }
            result.append(",");
            requestMap.put(var, oldVar);
            ++index;
        }
        return result.toString();
    }
}

