/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.dataview;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.icefaces.ace.util.Utils;
import org.icefaces.mobi.component.dataview.DataViewBase;
import org.icefaces.mobi.component.dataview.DataViewColumns;
import org.icefaces.mobi.component.dataview.DataViewDetails;
import org.icefaces.mobi.component.dataview.DataViewRenderer;
import org.icefaces.mobi.model.dataview.DataViewDataModel;
import org.icefaces.mobi.model.dataview.DataViewLazyDataModel;
import org.icefaces.mobi.model.dataview.DataViewListDataModel;
import org.icefaces.util.ClientDescriptor;

public class DataView
extends DataViewBase
implements NamingContainer {
    private static Logger logger = Logger.getLogger(DataViewRenderer.class.getName());
    public static final String DATAVIEW_CLASS = "mobi-dv ui-widget ui-widget-content";
    public static final String DATAVIEW_MASTER_CLASS = "mobi-dv-mst";
    public static final String DATAVIEW_DETAIL_CLASS = "mobi-dv-det ui-widget ui-widget-content";
    public static final String DATAVIEW_HEAD_CLASS = "mobi-dv-head";
    public static final String DATAVIEW_FOOT_CLASS = "mobi-dv-foot";
    public static final String DATAVIEW_BODY_CLASS = "mobi-dv-body";
    public static final String DATAVIEW_SORT_INDICATOR_CLASS = "mobi-dv-si";
    public static final String DATAVIEW_BOOL_COLUMN_CLASS = "mobi-dv-bool";
    public static final String DATAVIEW_COLUMN_CLASS = "mobi-dv-c";
    public static final String DATAVIEW_ROW_ACTIVE_CLASS = "ui-state-active";
    public static final String DATAVIEW_HEADER_ROW_CLASS = "ui-widget-header";
    protected static final DataViewDataModel EMPTY_DATA_MODEL = new DataViewListDataModel(Collections.EMPTY_LIST);
    private Map<String, Object> requestMap;
    private boolean decodedActive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block11: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            this.pushComponentToEL(facesContext, null);
            if (!this.decodedActive && this.getClientBehaviors().isEmpty() && !context.getFacesContext().getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW)) {
                this.decodeIndex(facesContext);
            }
            try {
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT) break block11;
                Iterator kids = this.getFacetsAndChildren();
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    boolean details = kid instanceof DataViewDetails;
                    if (details) {
                        this.initDetailContext(facesContext);
                    }
                    boolean done = kid.visitTree(context, callback);
                    if (details) {
                        this.clearDetailContext(facesContext);
                    }
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
            }
        }
        return false;
    }

    public void processUpdates(FacesContext context) {
        this.initDetailContext(context);
        super.processUpdates(context);
        this.clearDetailContext(context);
        if (!this.decodedActive) {
            this.decodeIndex(context);
        }
    }

    public void processValidators(FacesContext context) {
        this.initDetailContext(context);
        super.processValidators(context);
        this.clearDetailContext(context);
    }

    public void processDecodes(FacesContext context) {
        if (this.getClientBehaviors().isEmpty() && !this.decodedActive) {
            this.decodeIndex(context);
        }
        this.initDetailContext(context);
        super.processDecodes(context);
        this.clearDetailContext(context);
    }

    public Object processSaveState(FacesContext context) {
        this.initDetailContext(context);
        Object o = super.processSaveState(context);
        this.clearDetailContext(context);
        return o;
    }

    public void processRestoreState(FacesContext context, Object state) {
        this.initDetailContext(context);
        super.processRestoreState(context, state);
        this.clearDetailContext(context);
        if (this.getClientBehaviors().isEmpty() && !this.decodedActive) {
            this.decodeIndex(context);
        }
    }

    private void decodeIndex(FacesContext context) {
        String indexStr = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId() + "_active");
        if (indexStr != null && indexStr.length() > 0) {
            int newIndex = Integer.parseInt(indexStr);
            if (newIndex >= 0) {
                this.setActiveRowIndex(newIndex);
            } else {
                this.setActiveRowIndex(null);
            }
        }
        this.decodedActive = true;
    }

    public void clearDetailContext(FacesContext context) {
        this.getRequestMap(context).remove(this.getVar());
    }

    public void initDetailContext(FacesContext context) {
        Integer index = this.getActiveRowIndex();
        if (index != null && index >= 0) {
            this.getRequestMap(context).put(this.getVar(), this.getDataModel().getDataByIndex(index));
        }
    }

    private Map<String, Object> getRequestMap(FacesContext context) {
        if (this.requestMap == null) {
            this.requestMap = context.getExternalContext().getRequestMap();
        }
        return this.requestMap;
    }

    protected DataViewColumns getColumns() {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof DataViewColumns)) continue;
            return (DataViewColumns)child;
        }
        logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - doesn't have the nessecary 'ace:dataViewColumns' child component.");
        return null;
    }

    protected DataViewDataModel getDataModel() {
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof List) {
                return new DataViewListDataModel((List)value);
            }
            if (value instanceof DataViewLazyDataModel) {
                return (DataViewDataModel)value;
            }
            logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - Invalid type for 'value' attribute.");
            return EMPTY_DATA_MODEL;
        }
        logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - 'value' attribute is null.");
        return EMPTY_DATA_MODEL;
    }

    protected DataViewDetails getDetails() {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof DataViewDetails)) continue;
            return (DataViewDetails)child;
        }
        logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - doesn't have the nessecary 'ace:dataViewDetails' child component.");
        return null;
    }

    public ClientDescriptor getClient() {
        return Utils.getClientDescriptor();
    }
}

