/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.datespinner;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.icefaces.ace.util.Attribute;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.PassThruAttributeWriter;
import org.icefaces.ace.util.Utils;
import org.icefaces.mobi.component.datespinner.DateSpinner;
import org.icefaces.mobi.renderkit.InputRenderer;

public class DateSpinnerRenderer
extends InputRenderer {
    private static final Logger logger = Logger.getLogger(DateSpinnerRenderer.class.getName());
    private static final String JS_NAME = "datespinner.js";
    private static final String JS_MIN_NAME = "datespinner.c.js";
    private static final String JS_LIBRARY = "org.icefaces.component.datespinner";
    public static final String TOUCH_START_EVENT = "ontouchstart";
    public static final String CLICK_EVENT = "onclick";

    public void decode(FacesContext context, UIComponent component) {
        DateSpinner dateSpinner = (DateSpinner)component;
        String clientId = dateSpinner.getClientId(context);
        if (dateSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        if (this.shouldUseNative(dateSpinner)) {
            inputField = clientId;
        }
        String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField);
        String hiddenValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_hidden");
        boolean inputNull = this.isValueBlank(inputValue);
        boolean hiddenNull = this.isValueBlank(hiddenValue);
        if (!inputNull || inputNull && hiddenNull) {
            dateSpinner.setSubmittedValue(inputValue);
        } else if (hiddenNull) {
            dateSpinner.setSubmittedValue(hiddenValue);
        }
        this.decodeBehaviors(context, (UIComponent)dateSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DateSpinner spinner = (DateSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        spinner.setTouchEnabled(Utils.isTouchEventEnabled((FacesContext)context));
        String initialValue = ComponentUtils.getStringValueToRender((FacesContext)context, (UIComponent)component);
        if (this.shouldUseNative(spinner)) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"date", "type");
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            String styleClass = spinner.getStyleClass();
            String style = spinner.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "class");
            }
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            if (this.isValueBlank(initialValue)) {
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                writer.writeAttribute("value", (Object)initialValue, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            boolean noJs = false;
            if (readonly || disabled) {
                noJs = true;
            }
            if (!noJs && hasBehaviors) {
                String event = spinner.getDefaultEventName(context);
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                cbhCall = cbhCall.replace("\"", "'");
                writer.writeAttribute("onchange", (Object)("ice.ace.ab(" + cbhCall + ");"), null);
            }
            PassThruAttributeWriter.renderNonBooleanAttributes((ResponseWriter)writer, (UIComponent)component, (Attribute[])((DateSpinner)component).getCommonAttributeNames());
            writer.endElement("input");
        } else {
            this.writeJavascriptFile(context, component, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors);
            this.encodeScript(context, component);
        }
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner dateSpinner = (DateSpinner)uiComponent;
        String clientId = dateSpinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = dateSpinner.isTouchEnabled() ? TOUCH_START_EVENT : CLICK_EVENT;
        StringBuilder builder = new StringBuilder(255);
        StringBuilder builder2 = new StringBuilder(255);
        String inputCallStart = "mobi.datespinner.inputSubmit('";
        String jsCallStart = "mobi.datespinner.select('";
        builder2.append(clientId).append("',{ event: event");
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder2.append(behaviors);
        }
        builder2.append("});");
        boolean disabledOrReadonly = false;
        boolean disabled = dateSpinner.isDisabled();
        boolean readonly = dateSpinner.isReadonly();
        if (readonly || disabled) {
            disabledOrReadonly = true;
        }
        builder.append(jsCallStart).append((CharSequence)builder2);
        StringBuilder inputCall = new StringBuilder(inputCallStart).append((CharSequence)builder2);
        String jsCall = builder.toString();
        writer.startElement("span", uiComponent);
        String styleClass = dateSpinner.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-date-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        if (!disabledOrReadonly) {
            writer.writeAttribute("onblur", (Object)inputCall.toString(), null);
        }
        PassThruAttributeWriter.renderNonBooleanAttributes((ResponseWriter)writer, (UIComponent)uiComponent, (Attribute[])dateSpinner.getCommonAttributeNames());
        String style = dateSpinner.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        StringBuilder classNames = new StringBuilder("mobi-input-text");
        writer.writeAttribute("class", (Object)classNames.toString(), "class");
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-date-popup-btn", null);
        if (dateSpinner.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (!disabledOrReadonly) {
            writer.writeAttribute(CLICK_EVENT, (Object)("mobi.datespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-bg-inv", "class");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-container-inv ui-widget ui-widget-content", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-title-container ui-widget-header", null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"fa fa-calendar", null);
        writer.endElement("span");
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-title", null);
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-container ui-widget-content", null);
        String pattern = this.findPattern(dateSpinner);
        if (pattern != null) {
            int yStart = pattern.toLowerCase().indexOf("y");
            int mStart = pattern.toLowerCase().indexOf("m");
            int dStart = pattern.toLowerCase().indexOf("d");
            if (yStart < mStart && mStart < dStart) {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (yStart < dStart && dStart < mStart) {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (dStart < mStart && mStart < yStart) {
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (mStart < dStart && dStart < yStart) {
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            }
        } else {
            this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
        }
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-submit-container ui-widget-content", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        if (!dateSpinner.isDisabled() && !dateSpinner.isReadonly()) {
            writer.writeAttribute(CLICK_EVENT, (Object)(jsCall + "return false;"), null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(CLICK_EVENT, (Object)("mobi.datespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner spinner = (DateSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int yrInt = spinner.getYearInt();
        int mnthInt = spinner.getMonthInt();
        int dateInt = spinner.getDayInt();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("mobi.datespinner.init('" + clientId + "'," + yrInt + "," + mnthInt + "," + dateInt + ",'" + this.findPattern(spinner) + "');");
        writer.endElement("script");
        writer.endElement("span");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        DateSpinner spinner = (DateSpinner)component;
        String submittedValue = String.valueOf(value);
        Converter converter = spinner.getConverter();
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (converter != null) {
            Object objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            String pattern = this.findPattern(spinner);
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            format.setTimeZone(spinner.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private void renderDayInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_dUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dUp('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_dInt"), null);
        writer.write(String.valueOf(dateEntry.getDayInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_dDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dDn('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderMonthInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mUp('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(dateEntry.getMonthInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mDn('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderYearInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        int yMin = dateEntry.getYearStart();
        int yMax = dateEntry.getYearEnd();
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_yUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yUp('" + clientId + "'," + yMin + "," + yMax + ");return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_yInt"), null);
        writer.write(String.valueOf(dateEntry.getYearInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_yDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yDn('" + clientId + "'," + yMin + "," + yMax + ");return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void setIntValues(DateSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        spinner.setYearInt(cal.get(1));
        spinner.setMonthInt(cal.get(2) + 1);
        spinner.setDayInt(cal.get(5));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error converting string input.", e);
        }
        return returnString;
    }

    private String encodeValue(DateSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        String pattern = this.findPattern(spinner);
        SimpleDateFormat df2 = new SimpleDateFormat(pattern);
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, pattern)) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", pattern, initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private boolean shouldUseNative(DateSpinner component) {
        return component.isUseNative() && Utils.getClientDescriptor().isHasNativeDatePicker();
    }

    private void writePlusIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"fa fa-plus", null);
        writer.endElement("span");
    }

    private void writeMinusIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"fa fa-minus", null);
        writer.endElement("span");
    }

    private String findPattern(DateSpinner dateSpinner) {
        String pattern = dateSpinner.getPattern();
        Converter converter = dateSpinner.getConverter();
        if (converter != null && converter instanceof DateTimeConverter) {
            DateTimeConverter tmp = (DateTimeConverter)converter;
            pattern = tmp.getPattern();
        }
        return pattern;
    }
}

