/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.flipswitch;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.servlet.http.HttpServletRequest;
import org.icefaces.ace.util.Attribute;
import org.icefaces.ace.util.PassThruAttributeWriter;
import org.icefaces.mobi.component.flipswitch.FlipSwitch;
import org.icefaces.mobi.renderkit.CoreRenderer;
import org.icefaces.util.ClientDescriptor;

public class FlipSwitchRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(FlipSwitchRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        FlipSwitch flipswitch = (FlipSwitch)uiComponent;
        if (flipswitch.isDisabled()) {
            return;
        }
        String submittedString = String.valueOf(requestParameterMap.get(clientId + "_hidden"));
        if (submittedString != null) {
            boolean submittedValue = this.isChecked(submittedString);
            flipswitch.setSubmittedValue(submittedValue);
            this.decodeBehaviors(facesContext, (UIComponent)flipswitch);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        FlipSwitch flipswitch = (FlipSwitch)uiComponent;
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        writer.startElement("a", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        String styleClass = "mobi-flipswitch mobi-flipswitch-off ui-widget";
        String switchValue = String.valueOf(flipswitch.getValue());
        boolean isChecked = this.isChecked(switchValue);
        if (isChecked) {
            styleClass = "mobi-flipswitch mobi-flipswitch-on ui-widget";
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        PassThruAttributeWriter.renderNonBooleanAttributes((ResponseWriter)writer, (UIComponent)uiComponent, (Attribute[])flipswitch.getAttributesNames());
        PassThruAttributeWriter.renderBooleanAttributes((ResponseWriter)writer, (UIComponent)uiComponent, (Attribute[])flipswitch.getBooleanAttNames());
        String labelOn = flipswitch.getLabelOn();
        String labelOff = flipswitch.getLabelOff();
        boolean disabled = flipswitch.isDisabled();
        boolean readonly = flipswitch.isReadonly();
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.flipswitch.init('").append(clientId).append("',{ event: event,elVal: this");
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "action").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        if (this.isTransformerHack(facesContext)) {
            logger.finest("Transformer Prime hack active");
            builder.append(", transHack: 'true'");
        }
        builder.append("}); this.focus(); return false; ");
        String jsCall = builder.toString();
        if (!disabled && !readonly) {
            writer.writeAttribute("onclick", (Object)jsCall, null);
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        writer.startElement("span", null);
        boolean switchVal = (Boolean)flipswitch.getValue();
        writer.writeAttribute("class", (Object)("mobi-flipswitch-txt-on ui-button ui-corner-all ui-state-default" + (switchVal ? " ui-state-active" : "")), null);
        writer.write(labelOn);
        writer.endElement("span");
        this.writeHiddenField(uiComponent, clientId, writer, switchVal, disabled);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("mobi-flipswitch-txt-off ui-button ui-corner-all ui-state-default" + (!switchVal ? " ui-state-active" : "")), null);
        writer.write(labelOff);
        writer.endElement("span");
        writer.endElement("a");
    }

    private void writeHiddenField(UIComponent uiComponent, String clientId, ResponseWriter writer, boolean switchValue, boolean disabled) throws IOException {
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("value", (Object)switchValue, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
    }

    private boolean isChecked(String hiddenValue) {
        return hiddenValue.equalsIgnoreCase("true");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        return Boolean.valueOf(submittedValue.toString());
    }

    public boolean getRendersChildren() {
        return true;
    }

    private boolean isTransformerHack(FacesContext pageContext) {
        HttpServletRequest hsr;
        ClientDescriptor client;
        String ua;
        Object request = pageContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest && (ua = (client = ClientDescriptor.getInstance((HttpServletRequest)(hsr = (HttpServletRequest)request))).getUserAgent()) != null) {
            ua = ua.toLowerCase();
            return ua.contains("transformer prime");
        }
        return false;
    }
}

