/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.geotrack;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.util.CoreUtils;
import org.icefaces.mobi.component.geotrack.GeoTrack;
import org.icefaces.mobi.component.geotrack.GeoTrackResourceHandler;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class GeoTrackRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        String style;
        GeoTrack geotrack = (GeoTrack)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = geotrack.getClientId();
        writer.startElement("span", (UIComponent)geotrack);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("button", (UIComponent)geotrack);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        writer.writeAttribute("type", (Object)"button", null);
        if (geotrack.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if ((style = geotrack.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = geotrack.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.writeAttribute("tabindex", (Object)geotrack.getTabindex(), null);
        String script = "bridgeit.geoTrack('" + clientId + "', '', {postURL:'" + GeoTrackResourceHandler.getPostURL();
        script = script + "&__id=" + this.storeExpression(facesContext, geotrack) + "', ";
        String strategy = geotrack.getStrategy();
        script = script + "strategy:'" + strategy + "', duration:" + ("stop".equalsIgnoreCase(strategy) ? "0" : Double.valueOf(geotrack.getDuration()));
        String params = geotrack.getParameters();
        if (params != null && !"".equals(params.trim())) {
            script = script + ", " + params;
        }
        script = script + "});";
        writer.writeAttribute("onclick", (Object)script, null);
        writer.startElement("span", (UIComponent)geotrack);
        writer.write(geotrack.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", (UIComponent)geotrack);
        writer.startElement("script", (UIComponent)geotrack);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("new ice.mobi.button('" + clientId + "_button');");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        writer.endElement("span");
    }

    private String storeExpression(FacesContext facesContext, GeoTrack geotrack) {
        String name = CoreUtils.getSessionId((FacesContext)facesContext) + "_" + facesContext.getViewRoot().getViewId() + "_" + geotrack.getId();
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        applicationMap.put(name, geotrack.getValueExpression("publish"));
        return name;
    }
}

