/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.microphone;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.microphone.Microphone;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.util.MobiJSFUtils;

public class MicrophoneRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(MicrophoneRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Microphone microphone = (Microphone)uiComponent;
        String clientId = microphone.getClientId();
        if (microphone.isDisabled()) {
            return;
        }
        try {
            HashMap map = new HashMap();
            boolean valid = this.extractAudio(facesContext, map, clientId);
            if (valid && map != null) {
                microphone.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            logger.warning("Exception decoding audio stream: " + e);
        }
    }

    public boolean extractAudio(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        String style;
        Microphone microphone = (Microphone)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = microphone.getClientId();
        writer.startElement("span", microphone);
        writer.writeAttribute("id", clientId);
        String oldLabel = microphone.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)microphone)) {
            microphone.setButtonLabel(microphone.getCaptureMessageLabel());
        }
        writer.startElement("button", microphone);
        writer.writeAttribute("id", clientId + "_button");
        writer.writeAttribute("name", clientId + "_button");
        writer.writeAttribute("type", "button");
        if (microphone.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
        }
        if ((style = microphone.getStyle()) != null) {
            writer.writeAttribute("style", style);
        }
        if ((styleClass = microphone.getStyleClass()) != null) {
            writer.writeAttribute("class", styleClass);
        }
        writer.writeAttribute("tabindex", microphone.getTabindex());
        String script = "bridgeit.microphone('" + clientId + "', '', {postURL:'" + microphone.getPostURL() + "', " + "cookies:{'JSESSIONID':'" + MobiJSFUtils.getSessionIdCookie(facesContext) + "'}});";
        writer.writeAttribute("onclick", script);
        writer.startElement("span", microphone);
        writer.writeText(microphone.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", microphone);
        writer.startElement("script", microphone);
        writer.writeAttribute("type", "text/javascript");
        writer.writeText("new ice.mobi.button('" + clientId + "_button');");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        writer.endElement("span");
        microphone.setButtonLabel(oldLabel);
    }
}

